/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.teleporter;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.block.functional.portal.NowherePortalBlock;
import net.tslat.aoa3.content.block.functional.portal.PortalBlock;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;
import org.jetbrains.annotations.Nullable;

public interface AoAPortal
extends Portal {
    public static final IdentityHashMap<ResourceKey<Level>, List<BlockPos>> TRANSIENT_PORTAL_CACHE = new IdentityHashMap();

    public PortalBlock getPortalBlock();

    public Block getPortalFrame();

    default public DimensionTransition.PostDimensionTransition playTransitSound(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            return entity2 -> new SoundBuilder((Holder<SoundEvent>)AoASounds.PORTAL_EXIT).pitch(pl.getRandom().nextFloat() * 0.4f + 0.8f).category(SoundSource.AMBIENT).notInWorld().include(new Player[]{pl}).execute();
        }
        return DimensionTransition.PLAY_PORTAL_SOUND;
    }

    public static BlockPos makeSafeCoords(Level fromLevel, Level toLevel, Vec3 pos) {
        WorldBorder border = toLevel.getWorldBorder();
        double relativeScale = DimensionType.getTeleportationScale((DimensionType)fromLevel.dimensionType(), (DimensionType)toLevel.dimensionType());
        return border.clampToBounds(pos.x * relativeScale, pos.y, pos.z * relativeScale);
    }

    public static DimensionTransition getTransitionForLevel(ServerLevel destination, Entity entity, Block aoaPortalBlock) {
        GlobalPos globalPos;
        Optional<BlockPos> optional = Optional.empty();
        BlockPos blockPos = entity.blockPosition();
        PortalBlock portalBlock = (PortalBlock)aoaPortalBlock;
        if (entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            globalPos = PlayerUtil.getAdventPlayer((ServerPlayer)pl).storage.getPortalReturnFor((ResourceKey<Level>)entity.level().dimension());
        } else {
            globalPos = null;
        }
        return AoAPortal.getTransitionForLevel(destination, entity, optional, blockPos, portalBlock, Optional.ofNullable(globalPos));
    }

    public static DimensionTransition getTransitionForLevel(ServerLevel destination, Entity entity, Optional<BlockPos> fromPortal, BlockPos safeCoords, AoAPortal portal, Optional<GlobalPos> existingLink) {
        ServerLevel fromLevel = (ServerLevel)entity.level();
        BlockPos portalPos = AoAPortal.getOrCreatePortalLocation(destination, fromLevel, entity, safeCoords, portal, existingLink);
        fromPortal.ifPresent(portalBlock -> {
            if (entity instanceof ServerPlayer) {
                ServerPlayer pl = (ServerPlayer)entity;
                AoAPortal.updatePlayerLink(pl, portalBlock, (ResourceKey<Level>)fromLevel.dimension(), (ResourceKey<Level>)destination.dimension());
            }
        });
        return new DimensionTransition(destination, Vec3.atCenterOf((Vec3i)portalPos), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), portal.playTransitSound(entity).then(DimensionTransition.PLACE_PORTAL_TICKET));
    }

    public static BlockPos getOrCreatePortalLocation(ServerLevel destination, ServerLevel fromLevel, Entity entity, BlockPos safeCoords, AoAPortal portal, Optional<GlobalPos> existingLink) {
        BlockPos portalPos;
        if (entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            v0 = existingLink.filter(link -> link.dimension() == destination.dimension()).map(link -> portal.retrieveExistingLinkExit(pl, pl.serverLevel(), destination, (GlobalPos)link)).orElse(null);
        } else {
            v0 = portalPos = null;
        }
        if (fromLevel.getBlockState(entity.blockPosition()).getBlock() instanceof PortalBlock) {
            AoAPortal.updateLocalCache((Level)fromLevel, entity.blockPosition());
        }
        if (portalPos == null && entity instanceof ServerPlayer && WorldUtil.isWorld((Level)destination, AoADimensions.NOWHERE) && !portal.getClass().isAssignableFrom(NowherePortalBlock.class)) {
            portalPos = new BlockPos(16, 1003, 16);
        }
        if (portalPos == null) {
            portalPos = portal.findExistingPortal((Level)destination, entity, safeCoords);
        }
        if (portalPos == null) {
            portalPos = portal.findSuitablePortalLocation((Level)destination, entity, safeCoords);
            portalPos = portal.createPortalFrameAndSpace((Level)destination, entity, portalPos);
        }
        AoAPortal.updateLocalCache((Level)destination, portalPos);
        return portalPos;
    }

    public static void updatePlayerLink(ServerPlayer pl, BlockPos fromPortalBlockPos, ResourceKey<Level> fromDim, ResourceKey<Level> destinationDim) {
        GlobalPos returnPortalLoc;
        ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
        GlobalPos portalLoc = plData.storage.getPortalReturnFor(destinationDim);
        if (portalLoc != null && (returnPortalLoc = plData.storage.getPortalReturnFor(fromDim)) != null && returnPortalLoc.dimension() == destinationDim) {
            return;
        }
        if (portalLoc == null || fromDim == portalLoc.dimension() || pl.distanceToSqr(Vec3.atLowerCornerOf((Vec3i)portalLoc.pos())) > (double)((Integer)AoAConfigs.SERVER.portalSearchRadius.get() * (Integer)AoAConfigs.SERVER.portalSearchRadius.get())) {
            plData.storage.setPortalReturnLocation(destinationDim, fromDim, fromPortalBlockPos);
        }
    }

    @Nullable
    public static BlockPos getLocalCachedPos(Level level, BlockPos pos, Block portalBlock) {
        List<BlockPos> localPortalCache = TRANSIENT_PORTAL_CACHE.get(level.dimension());
        if (localPortalCache == null || localPortalCache.isEmpty()) {
            return null;
        }
        int range = AoAConfigs.SERVER.portalSearchRadius.getAsInt();
        BlockPos closest = null;
        double closestDistSqr = Double.MAX_VALUE;
        Iterator<BlockPos> positions = localPortalCache.iterator();
        while (positions.hasNext()) {
            BlockPos nextPos = positions.next();
            double distSqr = nextPos.distSqr((Vec3i)pos);
            if (!(distSqr <= (double)(range * range)) || !(distSqr < closestDistSqr)) continue;
            if (!level.getBlockState(nextPos).is(portalBlock)) {
                positions.remove();
                continue;
            }
            closest = nextPos;
            closestDistSqr = distSqr;
        }
        return closest;
    }

    public static BlockPos updateLocalCache(Level level, BlockPos pos) {
        TRANSIENT_PORTAL_CACHE.computeIfAbsent((ResourceKey<Level>)level.dimension(), key -> new ObjectArrayList()).add(pos.immutable());
        return pos;
    }

    @Nullable
    default public BlockPos retrieveExistingLinkExit(ServerPlayer player, ServerLevel currentWorld, ServerLevel destWorld, GlobalPos existingLink) {
        ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer(player);
        BlockPos locPos = existingLink.pos();
        BlockState state = destWorld.getBlockState(locPos);
        if (state.is((Block)this.getPortalBlock())) {
            return locPos;
        }
        if (!(state.getBlock() instanceof PortalBlock)) {
            plData.storage.removePortalReturnLocation((ResourceKey<Level>)currentWorld.dimension());
        }
        return null;
    }

    default public BlockPos findExistingPortal(Level targetLevel, Entity entity, BlockPos originPos) {
        BlockPos cachedPos = AoAPortal.getLocalCachedPos(targetLevel, originPos, this.getPortalBlock());
        if (cachedPos != null) {
            return cachedPos;
        }
        PortalBlock portalBlock = this.getPortalBlock();
        int searchRadius = (Integer)AoAConfigs.SERVER.portalSearchRadius.get();
        int worldHeight = targetLevel.getMaxBuildHeight();
        int worldFloor = targetLevel.getMinBuildHeight();
        int posX = Mth.floor((float)originPos.getX());
        int posY = originPos.getY() >= worldHeight ? 65 : Mth.floor((float)originPos.getY());
        int posZ = Mth.floor((float)originPos.getZ());
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(posX, posY, posZ);
        try (BulkSectionAccess sectionAccess = new BulkSectionAccess((LevelAccessor)targetLevel);){
            int z;
            int x;
            if (sectionAccess.getBlockState((BlockPos)checkPos).is((Block)portalBlock)) {
                while (sectionAccess.getBlockState((BlockPos)checkPos.move(Direction.DOWN)).is((Block)portalBlock)) {
                }
                BlockPos blockPos = AoAPortal.updateLocalCache(targetLevel, (BlockPos)checkPos);
                return blockPos;
            }
            for (int radius = 1; radius <= searchRadius; ++radius) {
                for (int y = posY - radius; y <= posY + radius; y += radius * 2) {
                    if (y < worldFloor || y >= worldHeight) continue;
                    int xNeg = -1;
                    for (int x2 = 0; x2 <= radius; ++x2) {
                        int x22 = posX + x2 * xNeg;
                        if (xNeg == 1 && x2 != 0) {
                            --x2;
                        }
                        xNeg *= -1;
                        int zNeg = -1;
                        for (int z2 = 0; z2 <= radius; ++z2) {
                            int z22 = posZ + z2 * zNeg;
                            if (zNeg == 1 && z2 != 0) {
                                --z2;
                            }
                            zNeg *= -1;
                            if (!sectionAccess.getBlockState((BlockPos)checkPos.set(x22, y, z22)).is((Block)portalBlock)) continue;
                            while (sectionAccess.getBlockState((BlockPos)checkPos.move(Direction.DOWN)).is((Block)portalBlock)) {
                            }
                            BlockPos blockPos = AoAPortal.updateLocalCache(targetLevel, checkPos.above());
                            return blockPos;
                        }
                    }
                }
                int yNeg = -1;
                for (int y = 0; y <= radius - 1; ++y) {
                    int y2 = posY + y * yNeg;
                    if (y2 < worldFloor || y2 >= worldHeight) continue;
                    if (yNeg == 1 && y != 0) {
                        --y;
                    }
                    yNeg *= -1;
                    int zNeg = -1;
                    for (int z3 = 0; z3 <= radius; ++z3) {
                        int z2 = posZ + z3 * zNeg;
                        if (zNeg == 1 && z3 != 0) {
                            --z3;
                        }
                        zNeg *= -1;
                        for (int x3 = -radius; x3 <= radius; x3 += radius * 2) {
                            int x2 = posX + x3;
                            if (!sectionAccess.getBlockState((BlockPos)checkPos.set(x2, y2, z2)).is((Block)portalBlock)) continue;
                            while (sectionAccess.getBlockState((BlockPos)checkPos.move(Direction.DOWN)).is((Block)portalBlock)) {
                            }
                            BlockPos blockPos = AoAPortal.updateLocalCache(targetLevel, checkPos.above());
                            return blockPos;
                        }
                    }
                    int xNeg = 1;
                    for (int x4 = 1; x4 <= radius - 1; ++x4) {
                        int x2 = posX + x4 * xNeg;
                        if (xNeg == 1 && x4 != 0) {
                            --x4;
                        }
                        xNeg *= -1;
                        for (int z4 = -radius; z4 <= radius; z4 += radius * 2) {
                            int z2 = posZ + z4;
                            if (!sectionAccess.getBlockState((BlockPos)checkPos.set(x2, y2, z2)).is((Block)portalBlock)) continue;
                            while (sectionAccess.getBlockState((BlockPos)checkPos.move(Direction.DOWN)).is((Block)portalBlock)) {
                            }
                            BlockPos blockPos = AoAPortal.updateLocalCache(targetLevel, checkPos.above());
                            return blockPos;
                        }
                    }
                }
            }
            for (x = posX - searchRadius; x <= posX + searchRadius; ++x) {
                for (z = posZ - searchRadius; z <= posZ + searchRadius; ++z) {
                    checkPos.set(x, posY - searchRadius, z);
                    while (!sectionAccess.getBlockState((BlockPos)checkPos.move(Direction.DOWN)).is((Block)portalBlock) && checkPos.getY() >= worldFloor) {
                    }
                    if (!sectionAccess.getBlockState((BlockPos)checkPos).is((Block)portalBlock)) continue;
                    while (sectionAccess.getBlockState((BlockPos)checkPos.move(Direction.DOWN)).is((Block)portalBlock)) {
                    }
                    BlockPos blockPos = checkPos.above(2).immutable();
                    return blockPos;
                }
            }
            for (x = posX - searchRadius; x <= posX + searchRadius; ++x) {
                for (z = posZ - searchRadius; z <= posZ + searchRadius; ++z) {
                    checkPos.set(x, posY + searchRadius, z);
                    while (!sectionAccess.getBlockState((BlockPos)checkPos.move(Direction.UP)).is((Block)portalBlock) && checkPos.getY() < worldHeight) {
                    }
                    if (!sectionAccess.getBlockState((BlockPos)checkPos).is((Block)portalBlock)) continue;
                    BlockPos blockPos = checkPos.above().immutable();
                    return blockPos;
                }
            }
        }
        return null;
    }

    default public BlockPos findSuitablePortalLocation(Level level, Entity entity, BlockPos originPos) {
        int searchRadius = (Integer)AoAConfigs.SERVER.portalSearchRadius.get();
        int worldFloor = level.getMinBuildHeight();
        int worldCeiling = worldFloor + level.dimensionType().logicalHeight();
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        int posX = Mth.floor((float)originPos.getX());
        int posY = originPos.getY() >= worldCeiling ? Math.min(worldCeiling, 65) : Mth.floor((float)originPos.getY());
        int posZ = Mth.floor((float)originPos.getZ());
        BlockPos fallbackPos = null;
        boolean isCleanSpawn = true;
        try (BulkSectionAccess sectionAccess = new BulkSectionAccess((LevelAccessor)level);){
            int y2;
            int z2;
            int x25;
            int y;
            int z;
            int x3;
            for (x3 = posX - 2; x3 <= posX + 2 && isCleanSpawn; ++x3) {
                for (z = posZ - 2; z <= posZ + 2 && isCleanSpawn; ++z) {
                    for (y = posY + 1; y <= posY + 6 && isCleanSpawn; ++y) {
                        if (y < worldCeiling && sectionAccess.getBlockState((BlockPos)checkPos.set(x3, y, z)).isAir()) continue;
                        isCleanSpawn = false;
                    }
                }
            }
            if (isCleanSpawn) {
                if (!sectionAccess.getBlockState((BlockPos)checkPos.set(posX, posY, posZ)).isAir()) {
                    BlockPos x3 = checkPos.set(posX, posY + 2, posZ).immutable();
                    return x3;
                }
                fallbackPos = checkPos.set(posX, posY + 2, posZ).immutable();
            }
            for (int radius = 1; radius <= searchRadius; ++radius) {
                for (int y3 = posY - radius; y3 <= posY + radius; y3 += radius * 2) {
                    if (y3 < worldFloor || y3 >= worldCeiling - 6) continue;
                    int xNeg = -1;
                    for (int x4 = 0; x4 <= radius; ++x4) {
                        int x22 = posX + x4 * xNeg;
                        if (xNeg == 1 && x4 != 0) {
                            --x4;
                        }
                        xNeg *= -1;
                        int zNeg = -1;
                        for (int z3 = 0; z3 <= radius; ++z3) {
                            int y32;
                            int z32;
                            int x32;
                            int z22 = posZ + z3 * zNeg;
                            if (zNeg == 1 && z3 != 0) {
                                --z3;
                            }
                            zNeg *= -1;
                            if (!sectionAccess.getBlockState((BlockPos)checkPos.set(x22, y3, z22)).isAir()) {
                                isCleanSpawn = true;
                                for (x32 = x22 - 2; x32 <= x22 + 2 && isCleanSpawn; ++x32) {
                                    for (z32 = z22 - 2; z32 <= z22 + 2 && isCleanSpawn; ++z32) {
                                        for (y32 = y3 + 1; y32 <= y3 + 6 && isCleanSpawn; ++y32) {
                                            if (sectionAccess.getBlockState((BlockPos)checkPos.set(x32, y32, z32)).isAir()) continue;
                                            isCleanSpawn = false;
                                        }
                                    }
                                }
                                if (!isCleanSpawn) continue;
                                BlockPos x32 = checkPos.set(x22, y3 + 2, z22).immutable();
                                return x32;
                            }
                            if (fallbackPos != null) continue;
                            isCleanSpawn = true;
                            for (x32 = x22 - 2; x32 <= x22 + 2 && isCleanSpawn; ++x32) {
                                for (z32 = z22 - 2; z32 <= z22 + 2 && isCleanSpawn; ++z32) {
                                    for (y32 = y3 + 1; y32 <= y3 + 6 && isCleanSpawn; ++y32) {
                                        if (sectionAccess.getBlockState((BlockPos)checkPos.set(x32, y32, z32)).isAir()) continue;
                                        isCleanSpawn = false;
                                    }
                                }
                            }
                            if (!isCleanSpawn) continue;
                            fallbackPos = checkPos.set(x22, y3 + 2, z22).immutable();
                        }
                    }
                }
                int yNeg = -1;
                for (y = 0; y <= radius - 1; ++y) {
                    int y22 = posY + y * yNeg;
                    if (y22 < 0 || y22 >= worldCeiling - 6) continue;
                    if (yNeg == 1 && y != 0) {
                        --y;
                    }
                    yNeg *= -1;
                    int zNeg = -1;
                    for (int z4 = 0; z4 <= radius; ++z4) {
                        int z23 = posZ + z4 * zNeg;
                        if (zNeg == 1 && z4 != 0) {
                            --z4;
                        }
                        zNeg *= -1;
                        for (int x5 = -radius; x5 <= radius; x5 += radius * 2) {
                            int y3;
                            int z3;
                            int x33;
                            int x23 = posX + x5;
                            if (!sectionAccess.getBlockState((BlockPos)checkPos.set(x23, y22, z23)).isAir()) {
                                isCleanSpawn = true;
                                for (x33 = x23 - 2; x33 <= x23 + 2 && isCleanSpawn; ++x33) {
                                    for (z3 = z23 - 2; z3 <= z23 + 2 && isCleanSpawn; ++z3) {
                                        for (y3 = y22 + 1; y3 <= y22 + 6 && isCleanSpawn; ++y3) {
                                            if (sectionAccess.getBlockState((BlockPos)checkPos.set(x33, y3, z3)).isAir()) continue;
                                            isCleanSpawn = false;
                                        }
                                    }
                                }
                                if (!isCleanSpawn) continue;
                                BlockPos x33 = checkPos.set(x23, y22 + 2, z23).immutable();
                                return x33;
                            }
                            if (fallbackPos != null) continue;
                            isCleanSpawn = true;
                            for (x33 = x23 - 2; x33 <= x23 + 2 && isCleanSpawn; ++x33) {
                                for (z3 = z23 - 2; z3 <= z23 + 2 && isCleanSpawn; ++z3) {
                                    for (y3 = y22 + 1; y3 <= y22 + 6 && isCleanSpawn; ++y3) {
                                        if (sectionAccess.getBlockState((BlockPos)checkPos.set(x33, y3, z3)).isAir()) continue;
                                        isCleanSpawn = false;
                                    }
                                }
                            }
                            if (!isCleanSpawn) continue;
                            fallbackPos = checkPos.set(x23, y22 + 2, z23).immutable();
                        }
                    }
                    int xNeg = 1;
                    for (int x6 = 1; x6 <= radius - 1; ++x6) {
                        int x24 = posX + x6 * xNeg;
                        if (xNeg == 1 && x6 != 0) {
                            --x6;
                        }
                        xNeg *= -1;
                        for (int z5 = -radius; z5 <= radius; z5 += radius * 2) {
                            int y3;
                            int z3;
                            int x34;
                            int z24 = posZ + z5;
                            if (!sectionAccess.getBlockState((BlockPos)checkPos.set(x24, y22, z24)).isAir()) {
                                isCleanSpawn = true;
                                for (x34 = x24 - 2; x34 <= x24 + 2 && isCleanSpawn; ++x34) {
                                    for (z3 = z24 - 2; z3 <= z24 + 2 && isCleanSpawn; ++z3) {
                                        for (y3 = y22 + 1; y3 <= y22 + 6 && isCleanSpawn; ++y3) {
                                            if (sectionAccess.getBlockState((BlockPos)checkPos.set(x34, y3, z3)).isAir()) continue;
                                            isCleanSpawn = false;
                                        }
                                    }
                                }
                                if (!isCleanSpawn) continue;
                                BlockPos x34 = checkPos.set(x24, y22 + 2, z24).immutable();
                                return x34;
                            }
                            if (fallbackPos != null) continue;
                            isCleanSpawn = true;
                            for (x34 = x24 - 2; x34 <= x24 + 2 && isCleanSpawn; ++x34) {
                                for (z3 = z24 - 2; z3 <= z24 + 2 && isCleanSpawn; ++z3) {
                                    for (y3 = y22 + 1; y3 <= y22 + 6 && isCleanSpawn; ++y3) {
                                        if (sectionAccess.getBlockState((BlockPos)checkPos.set(x34, y3, z3)).isAir()) continue;
                                        isCleanSpawn = false;
                                    }
                                }
                            }
                            if (!isCleanSpawn) continue;
                            fallbackPos = checkPos.set(x24, y22 + 2, z24).immutable();
                        }
                    }
                }
            }
            for (x3 = posX - searchRadius; x3 <= posX + searchRadius; ++x3) {
                for (z = posZ - searchRadius; z <= posZ + searchRadius; ++z) {
                    checkPos.set(x3, posY - searchRadius, z);
                    while (sectionAccess.getBlockState((BlockPos)checkPos.move(Direction.DOWN)).isAir() && checkPos.getY() >= 0) {
                    }
                    y = checkPos.getY();
                    isCleanSpawn = true;
                    for (x25 = x3 - 2; x25 <= x3 + 2 && isCleanSpawn; ++x25) {
                        for (z2 = z - 2; z2 <= z + 2 && isCleanSpawn; ++z2) {
                            for (y2 = y + 1; y2 <= y + 6 && isCleanSpawn; ++y2) {
                                if (sectionAccess.getBlockState((BlockPos)checkPos.set(x25, y2, z2)).isAir() && y2 < worldCeiling - 6) continue;
                                isCleanSpawn = false;
                            }
                        }
                    }
                    if (!isCleanSpawn || y < 0) continue;
                    BlockPos x25 = checkPos.set(x3, y + 2, z).immutable();
                    return x25;
                }
            }
            for (x3 = posX - searchRadius; x3 <= posX + searchRadius; ++x3) {
                for (z = posZ - searchRadius; z <= posZ + searchRadius; ++z) {
                    checkPos.set(x3, worldCeiling - 7, z);
                    while (sectionAccess.getBlockState((BlockPos)checkPos.move(Direction.DOWN)).isAir() && checkPos.getY() >= posY + searchRadius) {
                    }
                    y = checkPos.getY();
                    isCleanSpawn = true;
                    for (x25 = x3 - 2; x25 <= x3 + 2 && isCleanSpawn; ++x25) {
                        for (z2 = z - 2; z2 <= z + 2 && isCleanSpawn; ++z2) {
                            for (y2 = y + 1; y2 <= y + 6 && isCleanSpawn; ++y2) {
                                if (sectionAccess.getBlockState((BlockPos)checkPos.set(x25, y2, z2)).isAir()) continue;
                                isCleanSpawn = false;
                            }
                        }
                    }
                    if (!isCleanSpawn) continue;
                    BlockPos blockPos = checkPos.set(x3, y + 2, z).immutable();
                    return blockPos;
                }
            }
        }
        if (fallbackPos != null) {
            return fallbackPos;
        }
        return BlockPos.containing((double)originPos.getX(), (double)Math.clamp((long)(originPos.getY() + 2), worldFloor + 1, worldCeiling - 10), (double)originPos.getZ());
    }

    default public BlockPos createPortalFrameAndSpace(Level level, Entity entity, BlockPos pos) {
        int x;
        if (WorldUtil.isWorld(level, AoADimensions.OVERWORLD)) {
            return pos;
        }
        BlockPos returnPos = pos;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        BlockState border = this.getPortalFrame().defaultBlockState();
        Direction.Axis direction = EntityUtil.getDirectionFacing(entity, true).getAxis();
        BlockState portal = (BlockState)this.getPortalBlock().defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)(direction == Direction.Axis.X ? Direction.Axis.X : Direction.Axis.Z));
        int posX = pos.getX();
        int posY = pos.getY() - 1;
        int posZ = pos.getZ();
        if (!level.isEmptyBlock(pos)) {
            BlockState air = Blocks.AIR.defaultBlockState();
            for (int x2 = posX - 3; x2 <= posX + 3; ++x2) {
                for (int z = posZ - 3; z <= posZ + 3; ++z) {
                    for (int y = posY + 1; y <= posY + 4; ++y) {
                        level.setBlock((BlockPos)mutablePos.set(x2, y, z), air, 2);
                    }
                }
            }
        }
        if (direction == Direction.Axis.X) {
            for (int z = posZ - 2; z <= posZ + 2; ++z) {
                level.setBlock((BlockPos)mutablePos.set(posX, posY, z), border, 2);
                level.setBlock((BlockPos)mutablePos.set(posX, posY + 5, z), border, 2);
            }
            for (y = posY + 1; y <= posY + 4; ++y) {
                level.setBlock((BlockPos)mutablePos.set(posX, y, posZ - 2), border, 2);
                level.setBlock((BlockPos)mutablePos.set(posX, y, posZ - 1), portal, 2);
                level.setBlock((BlockPos)mutablePos.set(posX, y, posZ), portal, 2);
                level.setBlock((BlockPos)mutablePos.set(posX, y, posZ + 1), portal, 2);
                level.setBlock((BlockPos)mutablePos.set(posX, y, posZ + 2), border, 2);
            }
        } else {
            for (x = posX - 2; x <= posX + 2; ++x) {
                level.setBlock((BlockPos)mutablePos.set(x, posY, posZ), border, 2);
                level.setBlock((BlockPos)mutablePos.set(x, posY + 5, posZ), border, 2);
            }
            for (y = posY + 1; y <= posY + 4; ++y) {
                level.setBlock((BlockPos)mutablePos.set(posX - 2, y, posZ), border, 2);
                level.setBlock((BlockPos)mutablePos.set(posX - 1, y, posZ), portal, 2);
                level.setBlock((BlockPos)mutablePos.set(posX, y, posZ), portal, 2);
                level.setBlock((BlockPos)mutablePos.set(posX + 1, y, posZ), portal, 2);
                level.setBlock((BlockPos)mutablePos.set(posX + 2, y, posZ), border, 2);
            }
        }
        --posY;
        for (x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                mutablePos.set(posX + x, posY, posZ);
                if (level.getBlockState((BlockPos)mutablePos).isFaceSturdy((BlockGetter)level, (BlockPos)mutablePos, Direction.UP)) continue;
                this.createPortalBaseAndDecorations(level, new BlockPos(posX, posY, posZ), direction);
                return returnPos;
            }
        }
        return returnPos;
    }

    default public void createPortalBaseAndDecorations(Level level, BlockPos pos, Direction.Axis direction) {
        BlockState border = this.getPortalFrame().defaultBlockState();
        for (int x = pos.getX() - 2; x <= pos.getX() + 2; ++x) {
            for (int z = pos.getZ() - 2; z <= pos.getZ() + 2; ++z) {
                level.setBlock(new BlockPos(x, pos.getY(), z), border, 2);
            }
        }
    }
}

