/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.spawner;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public class VisualentSpawner
implements CustomSpawner {
    private int spawnCooldown = 18000;

    public int tick(ServerLevel world, boolean spawnHostiles, boolean spawnPassives) {
        if (this.spawnCooldown-- > 6000 || !spawnHostiles || !world.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) || world.getDifficulty() == Difficulty.PEACEFUL) {
            return 0;
        }
        if (RandomUtil.oneInNChance((int)Math.max(1, this.spawnCooldown))) {
            this.spawnCooldown = 6000;
        }
        return 0;
    }

    @Nullable
    private BlockPos findNearbySpawnPosition(ServerLevel world, BlockPos centerPos, int radius, int maxTries) {
        for (int i = 0; i < maxTries; ++i) {
            BlockPos pos = RandomUtil.getRandomPositionWithinRange((BlockPos)centerPos, (int)radius, (int)radius, (int)radius);
            if (world.getWorldBorder().isWithinBounds(pos) && !(centerPos.distSqr((Vec3i)pos) < 400.0)) continue;
        }
        return null;
    }
}

