/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.spawner;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.event.EventHooks;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.entity.AoACustomSpawners;
import net.tslat.aoa3.content.world.spawner.AoACustomSpawner;

public class RoamingTraderSpawner
implements AoACustomSpawner<Mob> {
    public static final MapCodec<RoamingTraderSpawner> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)AoACustomSpawner.GENERIC_SETTINGS_CODEC.fieldOf("base_settings").forGetter(spawner -> spawner.baseSettings), (App)Codec.lazyInitialized(() -> WeightedRandomList.codec((Codec)MobSpawnSettings.SpawnerData.CODEC)).fieldOf("spawns").forGetter(spawner -> spawner.spawns)).apply((Applicative)builder, RoamingTraderSpawner::new));
    private final AoACustomSpawner.GenericSettings baseSettings;
    private final WeightedRandomList<MobSpawnSettings.SpawnerData> spawns;
    private long nextSpawnTick = -1L;

    public RoamingTraderSpawner(AoACustomSpawner.GenericSettings baseSettings, WeightedRandomList<MobSpawnSettings.SpawnerData> spawns) {
        this.baseSettings = baseSettings;
        this.spawns = spawns;
    }

    @Override
    public boolean shouldAddToDimension(ServerLevel level) {
        if (level.isFlat() && !this.baseSettings.spawnInSuperflat()) {
            return false;
        }
        ResourceKey dimension = level.dimension();
        if (!dimension.location().getNamespace().equals("minecraft") && !AdventOfAscension.isAoA(dimension.location())) {
            return false;
        }
        if ((this.baseSettings.inDimensions().isEmpty() || this.baseSettings.inDimensions().get().isEmpty()) && (this.baseSettings.notInDimensions().isEmpty() || this.baseSettings.notInDimensions().get().isEmpty())) {
            return true;
        }
        return this.baseSettings.inDimensions().map(set -> set.contains(dimension)).orElse(true) != false && this.baseSettings.notInDimensions().map(set -> !set.contains(dimension)).orElse(true) != false;
    }

    public RoamingTraderSpawner copy() {
        return new RoamingTraderSpawner(this.baseSettings, this.spawns);
    }

    @Override
    public AoACustomSpawner.Type getType() {
        return (AoACustomSpawner.Type)AoACustomSpawners.ROAMING_TRADER.get();
    }

    public int tick(ServerLevel level, boolean spawnHostiles, boolean spawnPassives) {
        if (this.nextSpawnTick > level.getGameTime() || !spawnPassives || !level.getGameRules().getBoolean(GameRules.RULE_DO_TRADER_SPAWNING)) {
            return 0;
        }
        RandomSource random = level.getRandom();
        this.nextSpawnTick = level.getGameTime() + (long)this.baseSettings.spawnInterval().sample(random);
        return this.doSpawning(level, random);
    }

    @Override
    public boolean canSpawnInBiome(ServerLevel level, BlockPos pos) {
        if ((this.baseSettings.inBiomes().isEmpty() || this.baseSettings.inBiomes().get().size() == 0) && (this.baseSettings.notInBiomes().isEmpty() || this.baseSettings.notInBiomes().get().size() == 0)) {
            return true;
        }
        Holder biome = level.getBiome(pos);
        return this.baseSettings.inBiomes().map(set -> set.contains(biome)).orElse(true) != false && this.baseSettings.notInBiomes().map(set -> !set.contains(biome)).orElse(true) != false;
    }

    private int doSpawning(ServerLevel level, RandomSource random) {
        int count = 0;
        for (ServerPlayer pl2 : level.getPlayers(pl -> !pl.isSpectator() && pl.isAlive())) {
            if (level.getRandom().nextFloat() >= this.baseSettings.chancePerPlayer()) continue;
            for (Pair spawn : this.findNearbySpawnPositions(level, random, pl2.blockPosition(), 20, 64, this.baseSettings.spawnAttemptsPerPlayer().sample(random), () -> this.spawns.getRandom(random).map(data -> data.type))) {
                Entity entity;
                SpawnData.CustomSpawnRules spawnRules;
                EntityType entityType = (EntityType)spawn.left();
                BlockPos pos = (BlockPos)spawn.right();
                if (this.baseSettings.spawnRules().isPresent() && (!entityType.getCategory().isFriendly() && level.getDifficulty() == Difficulty.PEACEFUL || !(spawnRules = this.baseSettings.spawnRules().get()).blockLightLimit().isValueInRange((Comparable)Integer.valueOf(level.getBrightness(LightLayer.BLOCK, pos))) || !spawnRules.skyLightLimit().isValueInRange((Comparable)Integer.valueOf(level.getBrightness(LightLayer.SKY, pos)))) || !SpawnPlacements.isSpawnPositionOk((EntityType)entityType, (LevelReader)level, (BlockPos)pos) || !SpawnPlacements.checkSpawnRules((EntityType)entityType, (ServerLevelAccessor)level, (MobSpawnType)MobSpawnType.NATURAL, (BlockPos)pos, (RandomSource)level.random) || !level.noCollision(entityType.getSpawnAABB((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5)) || (entity = entityType.create(level, null, pos, MobSpawnType.NATURAL, false, false)) == null) continue;
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    if (this.baseSettings.spawnRules().isEmpty() && !mob.checkSpawnRules((LevelAccessor)level, MobSpawnType.NATURAL) || !mob.checkSpawnObstruction((LevelReader)level)) continue;
                    EventHooks.finalizeMobSpawn((Mob)mob, (ServerLevelAccessor)level, (DifficultyInstance)level.getCurrentDifficultyAt(pos), (MobSpawnType)MobSpawnType.NATURAL, null);
                }
                level.addFreshEntityWithPassengers(entity);
                this.nextSpawnTick += (long)this.baseSettings.extraDelayPerSpawn().sample(random);
                ++count;
            }
        }
        return count;
    }
}

