/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.spawner;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.Pair;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.entity.AoACustomSpawners;
import net.tslat.aoa3.common.registration.entity.AoAMiscEntities;
import net.tslat.aoa3.common.registration.entity.variant.PixonVariant;
import net.tslat.aoa3.content.entity.misc.PixonEntity;
import net.tslat.aoa3.content.world.spawner.AoACustomSpawner;

public class PixonSpawner
implements AoACustomSpawner<PixonEntity> {
    public static final MapCodec<PixonSpawner> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)AoACustomSpawner.GENERIC_SETTINGS_CODEC.fieldOf("base_settings").forGetter(spawner -> spawner.baseSettings), (App)Codec.lazyInitialized(() -> SimpleWeightedRandomList.wrappedCodec(AoARegistries.PIXON_VARIANTS.lookupCodec())).fieldOf("variants").forGetter(spawner -> spawner.variants)).apply((Applicative)builder, PixonSpawner::new));
    private final AoACustomSpawner.GenericSettings baseSettings;
    private final SimpleWeightedRandomList<PixonVariant> variants;
    private long nextSpawnTick = -1L;

    public PixonSpawner(AoACustomSpawner.GenericSettings baseSettings, SimpleWeightedRandomList<PixonVariant> variants) {
        this.baseSettings = baseSettings;
        this.variants = variants;
    }

    @Override
    public boolean shouldAddToDimension(ServerLevel level) {
        if (level.isFlat() && !this.baseSettings.spawnInSuperflat()) {
            return false;
        }
        ResourceKey dimension = level.dimension();
        if (!dimension.location().getNamespace().equals("minecraft") && !AdventOfAscension.isAoA(dimension.location())) {
            return false;
        }
        if ((this.baseSettings.inDimensions().isEmpty() || this.baseSettings.inDimensions().get().isEmpty()) && (this.baseSettings.notInDimensions().isEmpty() || this.baseSettings.notInDimensions().get().isEmpty())) {
            return true;
        }
        return this.baseSettings.inDimensions().map(set -> set.contains(dimension)).orElse(true) != false && this.baseSettings.notInDimensions().map(set -> !set.contains(dimension)).orElse(true) != false;
    }

    public PixonSpawner copy() {
        return new PixonSpawner(this.baseSettings, this.variants);
    }

    @Override
    public AoACustomSpawner.Type getType() {
        return (AoACustomSpawner.Type)AoACustomSpawners.PIXONS.get();
    }

    public int tick(ServerLevel level, boolean spawnHostiles, boolean spawnPassives) {
        if (this.nextSpawnTick > level.getGameTime() || !spawnPassives || !level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            return 0;
        }
        RandomSource random = level.getRandom();
        this.nextSpawnTick = level.getGameTime() + (long)this.baseSettings.spawnInterval().sample(random);
        return this.doSpawning(level, random);
    }

    private int doSpawning(ServerLevel level, RandomSource random) {
        int count = 0;
        for (ServerPlayer pl2 : level.getPlayers(pl -> !pl.isSpectator() && pl.isAlive())) {
            if (level.getRandom().nextFloat() >= this.baseSettings.chancePerPlayer()) continue;
            for (Pair spawn : this.findNearbySpawnPositions(level, random, pl2.blockPosition(), 40, 128, this.baseSettings.spawnAttemptsPerPlayer().sample(random) + (int)pl2.getAttributeValue(Attributes.LUCK), () -> Optional.of((EntityType)AoAMiscEntities.PIXON.get()))) {
                PixonEntity pixon;
                SpawnData.CustomSpawnRules spawnRules;
                if (this.baseSettings.spawnRules().isPresent() && (!(spawnRules = this.baseSettings.spawnRules().get()).blockLightLimit().isValueInRange((Comparable)Integer.valueOf(level.getBrightness(LightLayer.BLOCK, (BlockPos)spawn.right()))) || !spawnRules.skyLightLimit().isValueInRange((Comparable)Integer.valueOf(level.getBrightness(LightLayer.SKY, (BlockPos)spawn.right())))) || (pixon = (PixonEntity)((EntityType)spawn.left()).create(level, null, (BlockPos)spawn.right(), MobSpawnType.NATURAL, false, false)) == null) continue;
                pixon.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(pixon.blockPosition()), this.variants.getRandom(random).map(WeightedEntry.Wrapper::data).orElse(null));
                level.addFreshEntityWithPassengers((Entity)pixon);
                this.nextSpawnTick += (long)this.baseSettings.extraDelayPerSpawn().sample(random);
                ++count;
            }
        }
        return count;
    }

    @Override
    public boolean canSpawnAt(EntityType entityType, ServerLevel level, RandomSource random, BlockPos pos, SpawnPlacementType spawnPlacement) {
        return this.canSpawnInBiome(level, pos) && PixonSpawner.canSpawnOn(level, level.getBlockState(pos.below()), pos.below()) && PixonSpawner.canSpawnInside(level, level.getBlockState(pos), pos) && level.noCollision(entityType.getSpawnAABB((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5));
    }

    @Override
    public boolean canSpawnInBiome(ServerLevel level, BlockPos pos) {
        if ((this.baseSettings.inBiomes().isEmpty() || this.baseSettings.inBiomes().get().size() == 0) && (this.baseSettings.notInBiomes().isEmpty() || this.baseSettings.notInBiomes().get().size() == 0)) {
            return true;
        }
        Holder biome = level.getBiome(pos);
        return this.baseSettings.inBiomes().map(set -> set.contains(biome)).orElse(true) != false && this.baseSettings.notInBiomes().map(set -> !set.contains(biome)).orElse(true) != false;
    }

    private static boolean canSpawnOn(ServerLevel level, BlockState state, BlockPos pos) {
        return state.isValidSpawn((BlockGetter)level, pos, (EntityType)AoAMiscEntities.PIXON.get());
    }

    private static boolean canSpawnInside(ServerLevel level, BlockState state, BlockPos pos) {
        if (state.isCollisionShapeFullBlock((BlockGetter)level, pos)) {
            return false;
        }
        if (state.isSignalSource() || !level.getFluidState(pos).isEmpty()) {
            return false;
        }
        return !state.is(BlockTags.PREVENT_MOB_SPAWNING_INSIDE);
    }
}

