/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.structure.special;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.aoa3.common.registration.worldgen.AoAStructureTypes;
import net.tslat.aoa3.content.world.gen.structure.AoAJigsawAssembler;
import net.tslat.aoa3.content.world.gen.structure.AoAStructure;
import net.tslat.aoa3.content.world.gen.structure.TopAlignedStructure;

public class NethengeicPit
extends TopAlignedStructure {
    public static final MapCodec<NethengeicPit> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group(AoAStructure.Settings.aoaSettings()).apply((Applicative)codec, NethengeicPit::new));

    public NethengeicPit(AoAStructure.Settings settings) {
        super(settings);
    }

    @Override
    public StructureType<? extends AoAStructure> type() {
        return (StructureType)AoAStructureTypes.NETHENGEIC_PIT.get();
    }

    @Override
    protected AoAJigsawAssembler getJigsawAssembler() {
        return new AoAJigsawAssembler(){

            @Override
            protected Optional<Structure.GenerationStub> buildGenerationStub(PoolElementStructurePiece startPiece, BoundingBox startPieceBounds, Structure.GenerationContext genContext, int startX, int startY, int startZ, int maxPieces, int maxRadius, LiquidSettings liquidSettings) {
                WorldgenRandom rand = genContext.random();
                for (int i = 0; i < 5; ++i) {
                    int x = rand.nextInt(startPieceBounds.maxX() - startPieceBounds.minX());
                    int z = rand.nextInt(startPieceBounds.maxZ() - startPieceBounds.minZ());
                    if (genContext.chunkGenerator().getBaseColumn(startX + x, startZ + z, genContext.heightAccessor(), genContext.randomState()).getBlock(NethengeicPit.this.nextGenHeight).getBlock() == Blocks.LAVA) continue;
                    return Optional.empty();
                }
                return Optional.of(new Structure.GenerationStub(this.getStartPos(startPiece, startX, startY, startZ), pieceBuilder -> {
                    ObjectArrayList pieces = new ObjectArrayList();
                    pieces.add(startPiece);
                    if (maxPieces > 0) {
                        this.addPieces(genContext.randomState(), maxPieces, genContext.chunkGenerator(), genContext.structureTemplateManager(), genContext.heightAccessor(), (RandomSource)genContext.random(), (Registry<StructureTemplatePool>)genContext.registryAccess().registryOrThrow(Registries.TEMPLATE_POOL), startPiece, (List<PoolElementStructurePiece>)pieces, Shapes.join((VoxelShape)Shapes.create((AABB)new AABB((double)(startX - maxRadius), -4000.0, (double)(startZ - maxRadius), (double)(startX + maxRadius + 1), 4000.0, (double)(startZ + maxRadius + 1))), (VoxelShape)Shapes.create((AABB)AABB.of((BoundingBox)startPieceBounds)), (BooleanOp)BooleanOp.ONLY_FIRST), liquidSettings);
                        pieces.forEach(arg_0 -> ((StructurePiecesBuilder)pieceBuilder).addPiece(arg_0));
                    }
                    pieceBuilder.offsetPiecesVertically(NethengeicPit.this.nextGenHeight - startPieceBounds.maxY());
                }));
            }
        };
    }

    private boolean isInLava(Structure.GenerationContext context, Structure.GenerationStub genStub) {
        return true;
    }
}

