/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.structure.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.tslat.aoa3.common.registration.worldgen.AoAStructureProcessors;

public class TerrainAdaptionProcessor
extends StructureProcessor {
    public static final MapCodec<TerrainAdaptionProcessor> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)RuleTest.CODEC.fieldOf("pos_test").forGetter(TerrainAdaptionProcessor::posTest)).apply((Applicative)codec, TerrainAdaptionProcessor::new));
    private final RuleTest posTest;

    public TerrainAdaptionProcessor(RuleTest posTest) {
        this.posTest = posTest;
    }

    public RuleTest posTest() {
        return this.posTest;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)AoAStructureProcessors.TERRAIN_ADAPTION.get();
    }

    public List<StructureTemplate.StructureBlockInfo> finalizeProcessing(ServerLevelAccessor level, BlockPos posOffset, BlockPos blockPos, List<StructureTemplate.StructureBlockInfo> originalBlockData, List<StructureTemplate.StructureBlockInfo> modifiedBlockData, StructurePlaceSettings placementSettings) {
        for (StructureTemplate.StructureBlockInfo info : modifiedBlockData) {
            BlockState lastState;
            BlockPos pos = info.pos();
            if (!this.posTest.test(info.state(), level.getRandom()) || !level.getBlockState(pos.below()).isAir()) continue;
            ObjectArrayList toPlacePositions = new ObjectArrayList();
            while ((lastState = level.getBlockState(pos = pos.below())).isAir() && pos.getY() > level.getMinBuildHeight()) {
                toPlacePositions.add(pos);
            }
            if (pos.getY() == level.getMinBuildHeight()) {
                return modifiedBlockData;
            }
            for (BlockPos terrainPos : toPlacePositions) {
                level.setBlock(terrainPos, lastState, 2);
            }
        }
        return modifiedBlockData;
    }
}

