/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.structure.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.tslat.aoa3.common.registration.worldgen.AoAStructurePlacements;

public class SingleStructurePlacement
extends StructurePlacement {
    public static final MapCodec<SingleStructurePlacement> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)Codec.INT.fieldOf("salt").forGetter(SingleStructurePlacement::salt), (App)BlockPos.CODEC.fieldOf("pos").forGetter(SingleStructurePlacement::pos)).apply((Applicative)codec, SingleStructurePlacement::new));
    private final BlockPos pos;
    private final ChunkPos chunkPos;

    public SingleStructurePlacement(int salt, BlockPos pos) {
        super(Vec3i.ZERO, StructurePlacement.FrequencyReductionMethod.DEFAULT, 1.0f, salt, Optional.empty());
        this.pos = pos;
        this.chunkPos = new ChunkPos(pos);
    }

    public BlockPos pos() {
        return this.pos;
    }

    public int salt() {
        return super.salt();
    }

    protected boolean isPlacementChunk(ChunkGeneratorStructureState chunkGenerator, int chunkX, int chunkZ) {
        return this.chunkPos.x == chunkX && this.chunkPos.z == chunkZ;
    }

    public BlockPos getLocatePos(ChunkPos chunkPos) {
        return this.pos;
    }

    public StructurePlacementType<?> type() {
        return (StructurePlacementType)AoAStructurePlacements.SINGLE_STRUCTURE.get();
    }
}

