/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.placementmodifier;

import com.mojang.serialization.MapCodec;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.tslat.aoa3.common.registration.worldgen.AoAPlacementModifiers;

public class ChunkHighPoint
extends PlacementModifier {
    public static final MapCodec<ChunkHighPoint> CODEC = MapCodec.unit(ChunkHighPoint::new);

    private ChunkHighPoint() {
    }

    public static ChunkHighPoint instance() {
        return new ChunkHighPoint();
    }

    public PlacementModifierType<ChunkHighPoint> type() {
        return (PlacementModifierType)AoAPlacementModifiers.CHUNK_HIGH_POINT.get();
    }

    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        WorldGenLevel level = context.getLevel();
        int minX = pos.getX() - 12;
        int minZ = pos.getZ() - 12;
        int maxX = pos.getX() + 12;
        int maxZ = pos.getZ() + 12;
        AtomicReference<BlockPos> highestRingPos = new AtomicReference<BlockPos>(new BlockPos(pos.getX(), Integer.MIN_VALUE, pos.getZ()));
        return BlockPos.betweenClosedStream((BlockPos)new BlockPos(minX, pos.getY(), minZ), (BlockPos)new BlockPos(maxX, pos.getY(), maxZ)).map(pos1 -> {
            pos1 = pos1.immutable();
            while ((pos1 = pos1.above()).getY() < level.getMaxBuildHeight() && !level.getBlockState(pos1).isAir()) {
            }
            if (pos1.getY() > ((BlockPos)highestRingPos.get()).getY() && (pos1.getX() == minX || pos1.getX() == maxX || pos1.getZ() == minZ || pos1.getZ() == maxZ)) {
                highestRingPos.set(pos1.below());
            }
            return pos1.below();
        }).max(Comparator.comparingInt(Vec3i::getY)).filter(pos1 -> pos1.getY() > ((BlockPos)highestRingPos.get()).getY()).stream().map(BlockPos::below);
    }
}

