/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.feature.tree.trunkplacer;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.tslat.aoa3.common.registration.worldgen.AoATrees;
import net.tslat.aoa3.content.world.gen.feature.tree.trunkplacer.AoATrunkPlacer;

public class BaobabTrunkPlacer
extends AoATrunkPlacer {
    public static final MapCodec<BaobabTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(builder -> BaobabTrunkPlacer.heightValues(builder).apply((Applicative)builder, BaobabTrunkPlacer::new));

    public BaobabTrunkPlacer(IntProvider baseHeight, IntProvider additionalHeight) {
        super(baseHeight, additionalHeight);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)AoATrees.BAOBAB_TRUNK.get();
    }

    @Override
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos pos, TreeConfiguration config) {
        ObjectArrayList foliageAnchors = new ObjectArrayList();
        BlockPos soilPos = pos.below();
        int trunkX = pos.getX();
        int trunkY = pos.getY();
        int trunkZ = pos.getZ();
        int maxTrunkHeight = freeTreeHeight - random.nextInt(2, 4);
        int xOffset = trunkX;
        int zOffset = trunkZ;
        BlockPos.MutableBlockPos setterPos = new BlockPos.MutableBlockPos();
        BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)soilPos, (TreeConfiguration)config);
        BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)soilPos.east(), (TreeConfiguration)config);
        BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)soilPos.south(), (TreeConfiguration)config);
        BaobabTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)soilPos.south().east(), (TreeConfiguration)config);
        for (int i = 0; i < maxTrunkHeight; ++i) {
            setterPos.set(xOffset, trunkY + i, zOffset);
            if (!TreeFeature.isAirOrLeaves((LevelSimulatedReader)level, (BlockPos)setterPos)) continue;
            this.placeLog(level, blockSetter, random, (BlockPos)setterPos, config);
            this.placeLog(level, blockSetter, random, setterPos.east(), config);
            this.placeLog(level, blockSetter, random, setterPos.south(), config);
            this.placeLog(level, blockSetter, random, setterPos.east().south(), config);
        }
        ObjectArrayList branchDirections = ObjectArrayList.of((Object[])new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST});
        int extraBranches = random.nextInt(2, 4);
        for (int i = 0; i < extraBranches; ++i) {
            branchDirections.add(Direction.Plane.HORIZONTAL.getRandomDirection(random));
        }
        for (Direction branchDirection : branchDirections) {
            xOffset = trunkX;
            zOffset = trunkZ;
            if (branchDirection != Direction.NORTH && random.nextBoolean()) {
                zOffset += branchDirection.getStepZ();
            }
            if (branchDirection != Direction.WEST && random.nextBoolean()) {
                xOffset += branchDirection.getStepX();
            }
            int branchStartHeight = maxTrunkHeight - random.nextInt(2);
            int branchLength = 1 + freeTreeHeight / 5 + random.nextInt(3);
            OptionalInt foliageAnchorOffset = OptionalInt.empty();
            for (int j = branchStartHeight; j < freeTreeHeight && branchLength > 0; ++j, --branchLength) {
                if (j < 1) continue;
                int branchHeightOffset = pos.getY() + j;
                if (!this.placeLog(level, blockSetter, random, (BlockPos)setterPos.set(xOffset += branchDirection.getStepX(), branchHeightOffset, zOffset += branchDirection.getStepZ()), config)) continue;
                foliageAnchorOffset = OptionalInt.of(branchHeightOffset + 1);
            }
            if (!foliageAnchorOffset.isPresent()) continue;
            foliageAnchors.add(new FoliagePlacer.FoliageAttachment(new BlockPos(xOffset, foliageAnchorOffset.getAsInt(), zOffset), 0, false));
        }
        return foliageAnchors;
    }
}

