/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.feature.tree.trunkplacer;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.tslat.aoa3.common.registration.worldgen.AoATrees;
import net.tslat.aoa3.content.world.gen.feature.tree.trunkplacer.AoAGiantTrunkPlacer;

public class AoAGiantJungleTrunkPlacer
extends AoAGiantTrunkPlacer {
    public static final MapCodec<AoAGiantJungleTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(builder -> AoAGiantJungleTrunkPlacer.heightValues(builder).apply((Applicative)builder, AoAGiantJungleTrunkPlacer::new));

    public AoAGiantJungleTrunkPlacer(IntProvider baseHeight, IntProvider additionalHeight) {
        super(baseHeight, additionalHeight);
    }

    @Override
    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)AoATrees.AOA_GIANT_JUNGLE_TRUNK.get();
    }

    @Override
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos startPos, TreeConfiguration config) {
        ObjectArrayList foliagePoints = new ObjectArrayList(super.placeTrunk(level, blockSetter, random, freeTreeHeight, startPos, config));
        for (int yOffset = freeTreeHeight - 2 - random.nextInt(4); yOffset > freeTreeHeight / 2; yOffset -= 2 + random.nextInt(4)) {
            float angle = random.nextFloat() * ((float)Math.PI * 2);
            int xOffset = 0;
            int zOffset = 0;
            for (int step = 0; step < 5; ++step) {
                xOffset = (int)(1.5f + Mth.cos((float)angle) * (float)step);
                zOffset = (int)(1.5f + Mth.sin((float)angle) * (float)step);
                this.placeLog(level, blockSetter, random, startPos.offset(xOffset, yOffset - 3 + step / 2, zOffset), config);
            }
            foliagePoints.add(new FoliagePlacer.FoliageAttachment(startPos.offset(xOffset, yOffset, zOffset), -2, false));
        }
        return foliagePoints;
    }
}

