/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.feature.misc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.tslat.smartbrainlib.util.RandomUtil;

public class StructurePieceFeature
extends Feature<Configuration> {
    public StructurePieceFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        BlockPos pos = context.origin();
        Configuration config = (Configuration)context.config();
        RandomSource rand = context.random();
        WorldGenLevel reader = context.level();
        if (!config.requireGround() || !reader.getBlockState(pos.below()).canBeReplaced()) {
            config.getTemplate(context.level(), rand).placeInWorld((ServerLevelAccessor)reader, pos, pos, config.getPlacementSettings(rand), rand, 2);
        }
        return true;
    }

    public record Configuration(List<ResourceLocation> templatePaths, boolean doMirroring, boolean doRotations, boolean spawnEntities, boolean requireGround, Holder<StructureProcessorList> processors) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.CODEC.listOf().fieldOf("templates").forGetter(Configuration::templatePaths), (App)Codec.BOOL.optionalFieldOf("random_mirroring", (Object)true).forGetter(Configuration::doMirroring), (App)Codec.BOOL.optionalFieldOf("random_rotation", (Object)true).forGetter(Configuration::doRotations), (App)Codec.BOOL.optionalFieldOf("spawn_entities", (Object)true).forGetter(Configuration::spawnEntities), (App)Codec.BOOL.optionalFieldOf("require_ground", (Object)true).forGetter(Configuration::requireGround), (App)StructureProcessorType.LIST_CODEC.fieldOf("processors").forGetter(Configuration::processors)).apply((Applicative)builder, Configuration::new));

        public StructureTemplate getTemplate(WorldGenLevel level, RandomSource rand) {
            ResourceLocation templatePath = this.templatePaths.get(rand.nextInt(this.templatePaths.size()));
            return (StructureTemplate)level.getLevel().getStructureManager().get(templatePath).get();
        }

        public StructurePlaceSettings getPlacementSettings(RandomSource rand) {
            RandomUtil.EasyRandom random = new RandomUtil.EasyRandom(rand);
            StructurePlaceSettings settings = new StructurePlaceSettings();
            if (this.doMirroring) {
                settings.setMirror((Mirror)random.getRandomSelection((Object[])Mirror.values()));
            }
            if (this.doRotations) {
                settings.setRotation((Rotation)random.getRandomSelection((Object[])Rotation.values()));
            }
            settings.setIgnoreEntities(!this.spawnEntities);
            settings.setFinalizeEntities(this.spawnEntities);
            for (StructureProcessor processor : ((StructureProcessorList)this.processors.value()).list()) {
                settings.addProcessor(processor);
            }
            return settings;
        }

        public static class Builder {
            private final List<ResourceLocation> templatePaths;
            private boolean doMirroring = true;
            private boolean doRotations = true;
            private boolean spawnEntities = true;
            private boolean requireGround = true;
            private final List<StructureProcessor> processors = new ObjectArrayList(1);

            public Builder(ResourceLocation ... templatePaths) {
                this.templatePaths = Arrays.asList(templatePaths);
            }

            public Builder dontMirror() {
                this.doMirroring = false;
                return this;
            }

            public Builder dontRotate() {
                this.doRotations = false;
                return this;
            }

            public Builder ignoreEntities() {
                this.spawnEntities = false;
                return this;
            }

            public Builder spawnInMidair() {
                this.requireGround = false;
                return this;
            }

            public Builder withProcessors(StructureProcessor ... processors) {
                this.processors.addAll(Arrays.asList(processors));
                return this;
            }

            public Builder withProcessors(StructureProcessorList processorList) {
                this.processors.addAll(processorList.list());
                return this;
            }

            public Configuration build() {
                return new Configuration(this.templatePaths, this.doMirroring, this.doRotations, this.spawnEntities, this.requireGround, (Holder<StructureProcessorList>)Holder.direct((Object)new StructureProcessorList(this.processors)));
            }
        }
    }
}

