/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.feature.misc;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.OreFeature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.tslat.aoa3.library.object.PositionTableSet;

public class FluidOreFeature
extends OreFeature {
    public FluidOreFeature(Codec<OreConfiguration> codec) {
        super(codec);
    }

    protected boolean doPlace(WorldGenLevel level, RandomSource rand, OreConfiguration config, double minX, double maxX, double minZ, double maxZ, double minY, double maxY, int x, int y, int z, int width, int height) {
        int i;
        PositionTableSet placements = PositionTableSet.of(width, height, width);
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos();
        int size = config.size;
        double[] blobPoints = new double[size * 4];
        int placeCount = 0;
        for (i = 0; i < size; ++i) {
            float step = (float)i / (float)size;
            double blobSize = rand.nextDouble() * (double)size / 16.0;
            blobPoints[i * 4 + 0] = Mth.lerp((double)step, (double)minX, (double)maxX);
            blobPoints[i * 4 + 1] = Mth.lerp((double)step, (double)minY, (double)maxY);
            blobPoints[i * 4 + 2] = Mth.lerp((double)step, (double)minZ, (double)maxZ);
            blobPoints[i * 4 + 3] = ((double)(Mth.sin((float)((float)Math.PI * step)) + 1.0f) * blobSize + 1.0) / 2.0;
        }
        for (i = 0; i < size - 1; ++i) {
            if (blobPoints[i * 4 + 3] <= 0.0) continue;
            for (int j = i + 1; j < size; ++j) {
                double zSize;
                double ySize;
                double xSize;
                double radius;
                if (blobPoints[j * 4 + 3] <= 0.0 || !((radius = blobPoints[i * 4 + 3] - blobPoints[j * 4 + 3]) * radius > (xSize = blobPoints[i * 4 + 0] - blobPoints[j * 4 + 0]) * xSize + (ySize = blobPoints[i * 4 + 1] - blobPoints[j * 4 + 1]) * ySize + (zSize = blobPoints[i * 4 + 2] - blobPoints[j * 4 + 2]) * zSize)) continue;
                blobPoints[(radius > 0.0 ? j : i) * 4 + 3] = -1.0;
            }
        }
        for (i = 0; i < size; ++i) {
            double blobPointRadius = blobPoints[i * 4 + 3];
            if (blobPointRadius < 0.0) continue;
            double blobPointX = blobPoints[i * 4 + 0];
            double blobPointY = blobPoints[i * 4 + 1];
            double blobPointZ = blobPoints[i * 4 + 2];
            int blobMinX = Math.max(Mth.floor((double)(blobPointX - blobPointRadius)), x);
            int blobMinY = Math.max(Mth.floor((double)(blobPointY - blobPointRadius)), y);
            int blobMinZ = Math.max(Mth.floor((double)(blobPointZ - blobPointRadius)), z);
            int blobMaxX = Math.max(Mth.floor((double)(blobPointX + blobPointRadius)), blobMinX);
            int blobMaxY = Math.max(Mth.floor((double)(blobPointY + blobPointRadius)), blobMinY);
            int blobMaxZ = Math.max(Mth.floor((double)(blobPointZ + blobPointRadius)), blobMinZ);
            for (int oreX = blobMinX; oreX <= blobMaxX; ++oreX) {
                double oreXRadius = ((double)oreX + 0.5 - blobPointX) / blobPointRadius;
                if (oreXRadius * oreXRadius >= 1.0) continue;
                for (int oreY = blobMinY; oreY <= blobMaxY; ++oreY) {
                    double oreYRadius = ((double)oreY + 0.5 - blobPointY) / blobPointRadius;
                    if (oreXRadius * oreXRadius + oreYRadius * oreYRadius >= 1.0) continue;
                    block6: for (int oreZ = blobMinZ; oreZ <= blobMaxZ; ++oreZ) {
                        double oreZRadius = ((double)oreZ + 0.5 - blobPointZ) / blobPointRadius;
                        if (oreXRadius * oreXRadius + oreYRadius * oreYRadius + oreZRadius * oreZRadius >= 1.0 || level.isOutsideBuildHeight(oreY) || placements.isFilledAt(oreX - x, oreY - y, oreZ - z)) continue;
                        placements.add(oreX - x, oreY - y, oreZ - z);
                        testPos.set(oreX, oreY, oreZ);
                        if (!level.ensureCanWrite((BlockPos)testPos)) continue;
                        BlockState preOreState = level.getBlockState((BlockPos)testPos);
                        for (OreConfiguration.TargetBlockState targetState : config.targetStates) {
                            if (!FluidOreFeature.canPlaceOre((BlockState)preOreState, arg_0 -> ((WorldGenLevel)level).getBlockState(arg_0), (RandomSource)rand, (OreConfiguration)config, (OreConfiguration.TargetBlockState)targetState, (BlockPos.MutableBlockPos)testPos)) continue;
                            level.setBlock((BlockPos)testPos, targetState.state, 2);
                            if (!targetState.state.getFluidState().isEmpty()) {
                                level.scheduleTick(testPos.immutable(), targetState.state.getFluidState().getType(), 0);
                            }
                            ++placeCount;
                            continue block6;
                        }
                    }
                }
            }
        }
        return placeCount > 0;
    }
}

