/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.feature.lakes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.tslat.aoa3.library.object.PositionTableMap;
import net.tslat.smartbrainlib.util.RandomUtil;

public class BigLakeFeature
extends Feature<Configuration> {
    private static final int AIR = 1;
    private static final int FLUID = 2;
    private static final int BARRIER = 3;

    public BigLakeFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        WorldGenLevel level = context.level();
        RandomUtil.EasyRandom random = new RandomUtil.EasyRandom(context.random());
        Configuration config = (Configuration)context.config();
        int depth = config.maxFluidDepth().sample((RandomSource)random);
        BlockPos pos = context.origin().below(depth);
        if (pos.getY() <= level.getMinBuildHeight()) {
            return false;
        }
        int blobCount = config.sampleBlobCount().sample((RandomSource)random);
        int width = config.maxWidth().sample((RandomSource)random);
        boolean airGap = true;
        PositionTableMap lakePositions = PositionTableMap.of(width, depth + 1);
        for (int i = 0; i < blobCount; ++i) {
            float maxBlobWidthX = config.sampleBlobWidth().sample((RandomSource)random);
            float maxBlobHeight = config.sampleBlobHeight().sample((RandomSource)random);
            float maxBlobWidthZ = config.sampleBlobWidth().sample((RandomSource)random);
            float maxRadiusX = maxBlobWidthX / 2.0f;
            float maxRadiusY = maxBlobHeight / 2.0f;
            float maxRadiusZ = maxBlobWidthZ / 2.0f;
            double blobOffsetX = random.nextDouble() * ((double)((float)width - maxBlobWidthX) - 2.0) + 1.0 + (double)maxRadiusX;
            double blobOffsetY = random.nextDouble() * ((double)((float)(depth + 2) - maxBlobHeight) - 2.0) + 2.0 + (double)maxRadiusY;
            double blobOffsetZ = random.nextDouble() * ((double)((float)width - maxBlobWidthZ) - 2.0) + 1.0 + (double)maxRadiusZ;
            for (int x = 1; x < width - 1; ++x) {
                for (int z = 1; z < width - 1; ++z) {
                    for (int y = 1; y < 1 + depth; ++y) {
                        double xRadius = ((double)x - blobOffsetX) / (double)maxRadiusX;
                        double yRadius = ((double)y - blobOffsetY) / (double)maxRadiusY;
                        double zRadius = ((double)z - blobOffsetZ) / (double)maxRadiusZ;
                        if (!(xRadius * xRadius + yRadius * yRadius + zRadius * zRadius < 1.0)) continue;
                        lakePositions.set(x, y, z, y >= depth ? 1 : 2);
                    }
                }
            }
        }
        BlockState fluidState = config.fluid().getState((RandomSource)random, pos);
        for (Vec3i emptyPos : lakePositions.emptyPositions()) {
            if (lakePositions.isAtEdgeOfRegion(emptyPos.getX(), emptyPos.getY(), emptyPos.getZ()) || !lakePositions.isAdjacentFilled(emptyPos.getX(), emptyPos.getY(), emptyPos.getZ(), 2)) continue;
            BlockState barrierPreState = level.getBlockState(pos.offset(emptyPos));
            if (emptyPos.getY() >= depth ? barrierPreState.liquid() && barrierPreState != fluidState : !barrierPreState.isSolid() && barrierPreState != fluidState) {
                return false;
            }
            if (!barrierPreState.isSolid() || barrierPreState.is(BlockTags.LAVA_POOL_STONE_CANNOT_REPLACE)) continue;
            lakePositions.set(emptyPos, 3);
        }
        this.placeFluid(level, config, pos, depth, lakePositions);
        this.placeAir(level, config, pos, depth, lakePositions);
        this.placeBarrierBlocks(level, config, pos, depth, lakePositions);
        if (fluidState.getFluidState().is(FluidTags.WATER)) {
            this.freezeSurfaceWater(level, config, depth, pos, lakePositions);
        }
        return true;
    }

    protected void placeBarrierBlocks(WorldGenLevel level, Configuration config, BlockPos centerPos, int depth, PositionTableMap lakePositions) {
        BlockState barrierState = config.barrier().getState(level.getRandom(), centerPos);
        if (barrierState.isAir()) {
            return;
        }
        for (Vec3i pos : lakePositions.positionsForValue(3)) {
            BlockPos barrierPos = centerPos.offset(pos);
            if (pos.getY() >= depth && !level.getRandom().nextBoolean()) continue;
            level.setBlock(barrierPos, barrierState, 2);
            this.markAboveForPostProcessing(level, barrierPos);
        }
    }

    protected void placeAir(WorldGenLevel level, Configuration config, BlockPos centerPos, int depth, PositionTableMap lakePositions) {
        BlockState air = Blocks.CAVE_AIR.defaultBlockState();
        for (Vec3i pos : lakePositions.positionsForValue(1)) {
            BlockPos airPos = centerPos.offset(pos);
            if (!this.canReplaceBlock(level.getBlockState(airPos))) continue;
            level.setBlock(airPos, air, 2);
            level.scheduleTick(airPos, air.getBlock(), 0);
            this.markAboveForPostProcessing(level, airPos);
        }
    }

    protected void placeFluid(WorldGenLevel level, Configuration config, BlockPos centerPos, int depth, PositionTableMap lakePositions) {
        BlockState fluidState = config.fluid().getState(level.getRandom(), centerPos);
        for (Vec3i pos : lakePositions.positionsForValue(2)) {
            BlockPos fluidPos = centerPos.offset(pos);
            if (!this.canReplaceBlock(level.getBlockState(fluidPos))) continue;
            level.setBlock(fluidPos, fluidState, 2);
            if (pos.getY() < depth) continue;
            level.scheduleTick(fluidPos, fluidState.getFluidState().getType(), 0);
            this.markAboveForPostProcessing(level, fluidPos);
        }
    }

    protected void freezeSurfaceWater(WorldGenLevel level, Configuration config, int depth, BlockPos centerPos, PositionTableMap lakePositions) {
        BlockState ice = Blocks.ICE.defaultBlockState();
        for (Vec3i pos : lakePositions.positionsForValue(2)) {
            BlockPos icePos;
            if (pos.getY() < depth || !this.canReplaceBlock(level.getBlockState(icePos = centerPos.offset(pos))) || !((Biome)level.getBiome(icePos).value()).shouldFreeze((LevelReader)level, icePos, false)) continue;
            level.setBlock(icePos, ice, 2);
        }
    }

    private boolean canReplaceBlock(BlockState state) {
        return !state.is(BlockTags.FEATURES_CANNOT_REPLACE);
    }

    public record Configuration(BlockStateProvider fluid, BlockStateProvider barrier, IntProvider maxWidth, IntProvider maxFluidDepth, IntProvider sampleBlobCount, FloatProvider sampleBlobWidth, FloatProvider sampleBlobHeight) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("fluid").forGetter(Configuration::fluid), (App)BlockStateProvider.CODEC.fieldOf("barrier").forGetter(Configuration::barrier), (App)IntProvider.CODEC.optionalFieldOf("max_width", (Object)ConstantInt.of((int)16)).forGetter(Configuration::maxWidth), (App)IntProvider.CODEC.optionalFieldOf("max_fluid_depth", (Object)ConstantInt.of((int)4)).forGetter(Configuration::maxFluidDepth), (App)IntProvider.CODEC.optionalFieldOf("sample_blob_count", (Object)UniformInt.of((int)4, (int)8)).forGetter(Configuration::sampleBlobCount), (App)FloatProvider.CODEC.optionalFieldOf("sample_blob_width", (Object)UniformFloat.of((float)3.0f, (float)9.0f)).forGetter(Configuration::sampleBlobWidth), (App)FloatProvider.CODEC.optionalFieldOf("sample_blob_height", (Object)UniformFloat.of((float)2.0f, (float)6.0f)).forGetter(Configuration::sampleBlobHeight)).apply((Applicative)instance, Configuration::new));

        public Configuration(BlockStateProvider fluid, BlockStateProvider barrier) {
            this(fluid, barrier, (IntProvider)ConstantInt.of((int)16), (IntProvider)ConstantInt.of((int)4), (IntProvider)UniformInt.of((int)4, (int)8), (FloatProvider)UniformFloat.of((float)3.0f, (float)9.0f), (FloatProvider)UniformFloat.of((float)2.0f, (float)6.0f));
        }
    }
}

