/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.chunkgenerator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;

public class EmptyChunkGenerator
extends ChunkGenerator {
    public static final MapCodec<EmptyChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)BiomeSource.CODEC.fieldOf("biome_source").forGetter(p_255584_ -> p_255584_.biomeSource)).apply((Applicative)codec, EmptyChunkGenerator::new));
    private static final BlockState AIR = Blocks.AIR.defaultBlockState();

    public EmptyChunkGenerator(BiomeSource biomeSource) {
        super(biomeSource);
    }

    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    public void applyCarvers(WorldGenRegion region, long seed, RandomState random, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunkAccess, GenerationStep.Carving carvingStep) {
    }

    public void buildSurface(WorldGenRegion region, StructureManager structureManager, RandomState random, ChunkAccess chunkAccess) {
    }

    public void spawnOriginalMobs(WorldGenRegion region) {
    }

    public int getMinY() {
        return 0;
    }

    public int getGenDepth() {
        return 384;
    }

    public int getSeaLevel() {
        return 0;
    }

    public CompletableFuture<ChunkAccess> fillFromNoise(Blender blender, RandomState randomSatte, StructureManager structureManager, ChunkAccess chunkAccess) {
        return CompletableFuture.completedFuture(chunkAccess);
    }

    public int getBaseHeight(int posX, int posZ, Heightmap.Types heightmapType, LevelHeightAccessor heightAccessor, RandomState random) {
        return heightAccessor.getMinBuildHeight();
    }

    public NoiseColumn getBaseColumn(int posX, int posZ, LevelHeightAccessor heightAccessor, RandomState random) {
        Object[] columnData = new BlockState[heightAccessor.getHeight()];
        Arrays.fill(columnData, AIR);
        return new NoiseColumn(heightAccessor.getMinBuildHeight(), (BlockState[])columnData);
    }

    public void addDebugScreenInfo(List<String> debugLines, RandomState random, BlockPos pos) {
    }
}

