/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.gen.biome.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.tslat.aoa3.content.world.gen.BiomeMatcher;

public record NewFeatureBiomeModifier(BiomeMatcher biomeMatcher, GenerationStep.Decoration step, HolderSet<PlacedFeature> features) implements BiomeModifier
{
    public static final MapCodec<NewFeatureBiomeModifier> CODEC = RecordCodecBuilder.mapCodec(codec -> codec.group((App)BiomeMatcher.CODEC.fieldOf("biomes").forGetter(NewFeatureBiomeModifier::biomeMatcher), (App)GenerationStep.Decoration.CODEC.optionalFieldOf("gen_step", (Object)GenerationStep.Decoration.SURFACE_STRUCTURES).forGetter(NewFeatureBiomeModifier::step), (App)PlacedFeature.LIST_CODEC.fieldOf("features").forGetter(NewFeatureBiomeModifier::features)).apply((Applicative)codec, NewFeatureBiomeModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase != BiomeModifier.Phase.ADD) {
            return;
        }
        if (this.biomeMatcher.test(biome)) {
            this.features.forEach(feature -> builder.getGenerationSettings().addFeature(this.step, feature));
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return CODEC;
    }
}

