/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.event;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.WorldEventSyncPacket;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.content.world.event.AoAWorldEvent;
import org.apache.commons.lang3.tuple.Triple;

public class AoAWorldEventManager
extends SavedData {
    private static final SavedData.Factory<AoAWorldEventManager> FACTORY = new SavedData.Factory(AoAWorldEventManager::new, AoAWorldEventManager::new, null);
    private static final String DATA_KEY = "aoa_world_events";
    private static final AoAWorldEventManager CLIENT_INSTANCE = new AoAWorldEventManager();
    private final Map<ResourceLocation, AoAWorldEvent> events = new Object2ObjectArrayMap(2);
    private CompoundTag initData = null;

    private AoAWorldEventManager() {
    }

    private AoAWorldEventManager(CompoundTag tag, HolderLookup.Provider registryLookup) {
        this.initData = tag;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        for (AoAWorldEvent event : this.events.values()) {
            CompoundTag saveData = event.save();
            if (saveData == null) continue;
            tag.put(event.getId().toString(), (Tag)saveData);
        }
        return tag;
    }

    public static AoAWorldEvent getEventById(Level level, ResourceLocation id) {
        return AoAWorldEventManager.getForLevel((Level)level).events.getOrDefault(id, null);
    }

    public static boolean isEventActive(Level level, ResourceLocation id) {
        AoAWorldEventManager manager = AoAWorldEventManager.getForLevel(level);
        return manager.events.containsKey(id) && manager.events.get(id).isActive();
    }

    public static void tick(Level level) {
        AoAWorldEventManager.getForLevel((Level)level).events.values().forEach(ev -> ev.tick(level));
    }

    public static void syncToPlayer(ServerPlayer pl) {
        AoAWorldEventManager manager = AoAWorldEventManager.getForLevel(pl.level());
        ObjectArrayList events = new ObjectArrayList(manager.events.size());
        for (AoAWorldEvent event : manager.events.values()) {
            events.add(Triple.of(event.getType(), (Object)event.getId(), (Object)event.save()));
        }
        AoANetworking.sendToPlayer(pl, new WorldEventSyncPacket((List<Triple<AoAWorldEvent.Type<?>, ResourceLocation, CompoundTag>>)events));
    }

    public static void syncFromServer(List<Triple<AoAWorldEvent.Type<?>, ResourceLocation, CompoundTag>> events) {
        AoAWorldEventManager.CLIENT_INSTANCE.events.clear();
        for (Triple<AoAWorldEvent.Type<?>, ResourceLocation, CompoundTag> event : events) {
            AoAWorldEventManager.syncFromServer((AoAWorldEvent.Type)event.getLeft(), (ResourceLocation)event.getMiddle(), (CompoundTag)event.getRight());
        }
    }

    public static void syncFromServer(AoAWorldEvent.Type<?> eventType, ResourceLocation id, CompoundTag tag) {
        AoAWorldEventManager.CLIENT_INSTANCE.events.computeIfAbsent(id, key -> (AoAWorldEvent)eventType.clientConstructor().get()).load(tag);
    }

    public static void load(ServerLevel level) {
        List<AoAWorldEvent> events = level.getServer().registryAccess().registryOrThrow(AoARegistries.WORLD_EVENTS_REGISTRY_KEY).stream().filter(event -> event.shouldAddToDimension(level)).map(AoAWorldEvent::copy).toList();
        if (!events.isEmpty()) {
            AoAWorldEventManager manager = AoAWorldEventManager.getForLevel((Level)level);
            for (AoAWorldEvent event2 : events) {
                manager.events.put(event2.getId(), event2);
            }
            if (manager.initData != null) {
                for (AoAWorldEvent event2 : manager.events.values()) {
                    if (!manager.initData.contains(event2.getId().toString())) continue;
                    event2.load(manager.initData.getCompound(event2.getId().toString()));
                }
                manager.initData = null;
            }
        }
    }

    public static AoAWorldEventManager getForLevel(Level level) {
        if (level.isClientSide) {
            return CLIENT_INSTANCE;
        }
        return (AoAWorldEventManager)((ServerLevel)level).getDataStorage().computeIfAbsent(FACTORY, DATA_KEY);
    }

    public static void markDirty(ServerLevel level) {
        AoAWorldEventManager.getForLevel((Level)level).setDirty();
    }
}

