/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.event;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.WorldEventUpdatePacket;
import net.tslat.aoa3.content.world.event.AoAWorldEventManager;

public interface AoAWorldEvent {
    public void setActive(boolean var1);

    public boolean isActive();

    public boolean shouldAddToDimension(ServerLevel var1);

    public void tick(Level var1);

    public AoAWorldEvent copy();

    public ResourceLocation getId();

    public Type<? extends AoAWorldEvent> getType();

    public CompoundTag save();

    public void load(CompoundTag var1);

    public void start(ServerLevel var1);

    public void stop(ServerLevel var1);

    default public void markDirty(ServerLevel level) {
        AoAWorldEventManager.markDirty(level);
        AoANetworking.sendToAllInLevel(level, new WorldEventUpdatePacket(this.getType(), this.getId(), this.save()));
    }

    public record Type<E extends AoAWorldEvent>(MapCodec<E> codec, Supplier<E> clientConstructor) {
    }

    public record GenericSettings(ResourceLocation id, Set<ResourceKey<Level>> dimensions) {
        public static final Codec<GenericSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(GenericSettings::id), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).listOf().xmap(Set::copyOf, List::copyOf).fieldOf("dimensions").forGetter(GenericSettings::dimensions)).apply((Applicative)builder, GenericSettings::new));
    }
}

