/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.skill.hauling;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.library.object.RandomEntryPool;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;

public record HaulingEntity(Either<ItemStack, EntityType<?>> object, Optional<CompoundTag> spawnData, int weight, int levelReq, float luckMod) implements BiFunction<Level, Boolean, Entity>
{
    public static Codec<HaulingEntity> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.mapEither((MapCodec)ItemStack.STRICT_CODEC.fieldOf("item"), (MapCodec)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entity")).fieldOf("object_id").forGetter(entry -> entry.object), (App)CompoundTag.CODEC.optionalFieldOf("spawn_data").forGetter(entry -> entry.spawnData), (App)Codec.INT.fieldOf("weight").forGetter(entry -> entry.weight), (App)Codec.INT.optionalFieldOf("hauling_level_req", (Object)0).forGetter(entry -> entry.levelReq), (App)Codec.FLOAT.optionalFieldOf("luck_mod", (Object)Float.valueOf(0.0f)).forGetter(entry -> Float.valueOf(entry.luckMod))).apply((Applicative)instance, HaulingEntity::new));

    public RandomEntryPool.PoolEntry<HaulingEntity, ServerPlayer> toPoolEntry() {
        return new RandomEntryPool.PoolEntry<HaulingEntity, ServerPlayer>(this, this.weight(), this.luckMod(), pl -> this.weight() <= 0 || PlayerUtil.doesPlayerHaveLevel((Player)pl, (AoASkill)AoASkills.HAULING.get(), this.levelReq()));
    }

    @Override
    public Entity apply(Level level, final Boolean isInLava) {
        return (Entity)this.object().map(stack -> {
            ItemEntity entity = new ItemEntity(this, EntityType.ITEM, level){

                public boolean fireImmune() {
                    return isInLava != false || super.fireImmune();
                }
            };
            entity.setItem(stack.copy());
            entity.setNeverPickUp();
            return entity;
        }, entityType -> {
            Entity entity = entityType.create(level);
            this.spawnData().ifPresent(arg_0 -> ((Entity)entity).load(arg_0));
            return entity;
        });
    }
}

