/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.menu.generic.GenericRecipeInput;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.recipe.RecipeBookRecipe;
import net.tslat.aoa3.util.RecipeUtil;
import org.jetbrains.annotations.Nullable;

public record WhitewashingRecipe(RecipeUtil.RecipeBookDetails recipeBookDetails, Ingredient input, Ingredient washingMaterial, ItemStack output) implements RecipeBookRecipe<GenericRecipeInput>
{
    public WhitewashingRecipe(String group, @Nullable CraftingBookCategory category, boolean showObtainNotification, Ingredient input, Ingredient washingMaterial, ItemStack output) {
        this(new RecipeUtil.RecipeBookDetails(group, category, showObtainNotification), input, washingMaterial, output);
    }

    public RecipeSerializer<WhitewashingRecipe> getSerializer() {
        return (RecipeSerializer)AoARecipes.WHITEWASHING.serializer().get();
    }

    public RecipeType<WhitewashingRecipe> getType() {
        return (RecipeType)AoARecipes.WHITEWASHING.type().get();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)AoABlocks.WHITEWASHING_TABLE.get());
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 3;
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of(null, (Object[])new Ingredient[]{this.input, this.washingMaterial});
    }

    public boolean matches(GenericRecipeInput inv, Level world) {
        return this.input.test(inv.getItem(0)) && this.washingMaterial.test(inv.getItem(1));
    }

    public ItemStack assemble(GenericRecipeInput recipeInput, HolderLookup.Provider holderLookup) {
        return this.getResultItem(holderLookup);
    }

    public ItemStack getResultItem(HolderLookup.Provider holderLookup) {
        return this.output.copy();
    }

    public static class Factory
    implements RecipeSerializer<WhitewashingRecipe> {
        public static final MapCodec<WhitewashingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> RecipeUtil.RecipeBookDetails.codec(builder, instance -> instance.recipeBookDetails).and(builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(instance -> instance.input), (App)Ingredient.CODEC_NONEMPTY.fieldOf("washing_material").forGetter(instance -> instance.washingMaterial), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(instance -> instance.output))).apply((Applicative)builder, WhitewashingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, WhitewashingRecipe> STREAM_CODEC = StreamCodec.composite(RecipeUtil.RecipeBookDetails.STREAM_CODEC, recipe -> recipe.recipeBookDetails, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.input, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.washingMaterial, (StreamCodec)ItemStack.STREAM_CODEC, recipe -> recipe.output, WhitewashingRecipe::new);

        public MapCodec<WhitewashingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, WhitewashingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

