/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.content.recipe.RecipeBookRecipe;
import net.tslat.aoa3.util.CodecUtil;
import net.tslat.aoa3.util.RecipeUtil;
import org.jetbrains.annotations.Nullable;

public class ToolInteractionRecipe
extends CustomRecipe
implements RecipeBookRecipe<CraftingInput> {
    private final RecipeUtil.RecipeBookDetails recipeBookDetails;
    private final NonNullList<Ingredient> ingredients;
    private final Ingredient toolItem;
    private final ItemStack output;

    public ToolInteractionRecipe(String group, @Nullable CraftingBookCategory category, boolean showObtainNotification, NonNullList<Ingredient> ingredients, Ingredient toolItem, ItemStack output) {
        this(new RecipeUtil.RecipeBookDetails(group, category, showObtainNotification), ingredients, toolItem, output);
    }

    public ToolInteractionRecipe(RecipeUtil.RecipeBookDetails recipeBookDetails, NonNullList<Ingredient> ingredients, Ingredient toolItem, ItemStack output) {
        super(recipeBookDetails.category());
        this.recipeBookDetails = recipeBookDetails;
        this.ingredients = ingredients;
        this.toolItem = toolItem;
        this.output = output;
    }

    @Override
    public RecipeUtil.RecipeBookDetails recipeBookDetails() {
        return this.recipeBookDetails;
    }

    public RecipeSerializer<ToolInteractionRecipe> getSerializer() {
        return (RecipeSerializer)AoARecipes.TOOL_INTERACTION.serializer().get();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.ingredients.size() + 1;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean matches(CraftingInput input, Level level) {
        if (this.ingredients.size() != input.ingredientCount()) {
            return false;
        }
        boolean hasTool = false;
        for (ItemStack stack : input.items()) {
            if (!this.toolItem.test(stack)) continue;
            hasTool = true;
            break;
        }
        return hasTool && input.stackedContents().canCraft((Recipe)this, null);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        NonNullList returns = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        boolean hasTool = false;
        for (int i = 0; i < returns.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (!hasTool && this.toolItem.test(stack)) {
                ItemStack toolCopy = stack.copy();
                if (toolCopy.isDamageableItem()) {
                    toolCopy.setDamageValue(toolCopy.getDamageValue() + 1);
                }
                if (!toolCopy.isDamageableItem() || toolCopy.getDamageValue() < toolCopy.getMaxDamage()) {
                    returns.set(i, (Object)toolCopy);
                }
                hasTool = true;
                continue;
            }
            if (!stack.hasCraftingRemainingItem()) continue;
            returns.set(i, (Object)stack.getCraftingRemainingItem());
        }
        return returns;
    }

    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider holderLookup) {
        return this.getResultItem(holderLookup);
    }

    public ItemStack getResultItem(HolderLookup.Provider holderLookup) {
        return this.output.copy();
    }

    public static class Factory
    implements RecipeSerializer<ToolInteractionRecipe> {
        public static final MapCodec<ToolInteractionRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> RecipeUtil.RecipeBookDetails.codec(builder, instance -> instance.recipeBookDetails).and(builder.group(RecipeUtil.shapelessIngredientCodec("ToolInteractionRecipe", "ingredients", ShapedRecipePattern.getMaxWidth() * ShapedRecipePattern.getMaxHeight() - 1, ToolInteractionRecipe::getIngredients), (App)Ingredient.CODEC_NONEMPTY.fieldOf("tool").forGetter(instance -> instance.toolItem), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(instance -> instance.output))).apply((Applicative)builder, ToolInteractionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ToolInteractionRecipe> STREAM_CODEC = StreamCodec.composite(RecipeUtil.RecipeBookDetails.STREAM_CODEC, recipe -> recipe.recipeBookDetails, CodecUtil.streamNonNullList(Ingredient.CONTENTS_STREAM_CODEC, Ingredient.EMPTY), recipe -> recipe.ingredients, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.toolItem, (StreamCodec)ItemStack.STREAM_CODEC, recipe -> recipe.output, ToolInteractionRecipe::new);

        public MapCodec<ToolInteractionRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ToolInteractionRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

