/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.recipe;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.content.item.datacomponent.StaffRuneCost;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.content.recipe.RecipeBookRecipe;
import net.tslat.aoa3.util.RecipeUtil;
import org.jetbrains.annotations.Nullable;

public class StaffChargingRecipe
extends CustomRecipe
implements RecipeBookRecipe<CraftingInput> {
    private final RecipeUtil.RecipeBookDetails recipeBookDetails;

    public StaffChargingRecipe(String group, @Nullable CraftingBookCategory category, boolean showObtainNotification) {
        this(new RecipeUtil.RecipeBookDetails(group, category, showObtainNotification));
    }

    public StaffChargingRecipe(RecipeUtil.RecipeBookDetails recipeBookDetails) {
        super(recipeBookDetails.category());
        this.recipeBookDetails = recipeBookDetails;
    }

    @Override
    public RecipeUtil.RecipeBookDetails recipeBookDetails() {
        return this.recipeBookDetails;
    }

    public RecipeSerializer<StaffChargingRecipe> getSerializer() {
        return (RecipeSerializer)AoARecipes.STAFF_CHARGING.serializer().get();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public boolean matches(CraftingInput input, Level level) {
        Object2IntArrayMap foundItems = new Object2IntArrayMap();
        Object2IntMap<Item> runeCosts = null;
        for (ItemStack stack : input.items()) {
            if (runeCosts == null && stack.has(AoADataComponents.STORED_SPELL_CASTS)) {
                BaseStaff.StoredCasts storedCasts = (BaseStaff.StoredCasts)stack.get(AoADataComponents.STORED_SPELL_CASTS);
                if (storedCasts.stored() < 0 || storedCasts.stored() >= storedCasts.max().orElse(Integer.MAX_VALUE)) {
                    return false;
                }
                runeCosts = stack.has(AoADataComponents.STAFF_RUNE_COST) ? ((StaffRuneCost)stack.get(AoADataComponents.STAFF_RUNE_COST)).runeCosts() : null;
                continue;
            }
            if (stack.isEmpty()) continue;
            foundItems.mergeInt((Object)stack.getItem(), stack.getCount(), Integer::sum);
        }
        if (foundItems.isEmpty() || runeCosts == null || foundItems.size() != runeCosts.size()) {
            return false;
        }
        for (Object2IntMap.Entry foundItem : foundItems.object2IntEntrySet()) {
            if (runeCosts.containsKey(foundItem.getKey())) continue;
            return false;
        }
        for (Object2IntMap.Entry runeCost : runeCosts.object2IntEntrySet()) {
            if (foundItems.containsKey(runeCost.getKey()) && foundItems.getInt(runeCost.getKey()) >= runeCost.getIntValue()) continue;
            return false;
        }
        return true;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        int i;
        NonNullList remainingItems = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        Object2IntArrayMap runeCosts = null;
        for (i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.has(AoADataComponents.STORED_SPELL_CASTS) && stack.has(AoADataComponents.STAFF_RUNE_COST)) {
                runeCosts = new Object2IntArrayMap(((StaffRuneCost)stack.get(AoADataComponents.STAFF_RUNE_COST)).runeCosts());
                continue;
            }
            remainingItems.set(i, (Object)stack);
        }
        if (runeCosts == null || runeCosts.isEmpty()) {
            return remainingItems;
        }
        i = 0;
        while (i < remainingItems.size()) {
            int slot = i++;
            ItemStack stack = (ItemStack)remainingItems.get(slot);
            runeCosts.computeIntIfPresent((Object)stack.getItem(), (item, remaining) -> {
                if (remaining < stack.getCount()) {
                    remainingItems.set(slot, (Object)stack.copyWithCount(stack.getCount() - remaining));
                    return 0;
                }
                remainingItems.set(slot, (Object)ItemStack.EMPTY);
                return Math.max(0, remaining - stack.getCount());
            });
            stack.setCount(0);
        }
        return remainingItems;
    }

    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider holderLookup) {
        for (ItemStack stack : inventory.items()) {
            if (!stack.has(AoADataComponents.STORED_SPELL_CASTS) || !stack.has(AoADataComponents.STAFF_RUNE_COST)) continue;
            ItemStack newStack = stack.copy();
            newStack.set(AoADataComponents.STORED_SPELL_CASTS, (Object)BaseStaff.StoredCasts.increment((BaseStaff.StoredCasts)stack.get(AoADataComponents.STORED_SPELL_CASTS)));
            return newStack;
        }
        return ItemStack.EMPTY;
    }

    public static class Factory
    implements RecipeSerializer<StaffChargingRecipe> {
        public static final MapCodec<StaffChargingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> RecipeUtil.RecipeBookDetails.codec(builder, instance -> instance.recipeBookDetails).apply((Applicative)builder, StaffChargingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, StaffChargingRecipe> STREAM_CODEC = StreamCodec.composite(RecipeUtil.RecipeBookDetails.STREAM_CODEC, recipe -> recipe.recipeBookDetails, StaffChargingRecipe::new);

        public MapCodec<StaffChargingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, StaffChargingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

