/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import net.tslat.aoa3.common.menu.generic.GenericRecipeInput;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.recipe.RecipeBookRecipe;
import net.tslat.aoa3.util.CodecUtil;
import net.tslat.aoa3.util.RecipeUtil;
import org.jetbrains.annotations.Nullable;

public record InfusionRecipe(RecipeUtil.RecipeBookDetails recipeBookDetails, NonNullList<Ingredient> ingredients, Ingredient input, ItemStack output, boolean isSimple) implements RecipeBookRecipe<GenericRecipeInput>
{
    public InfusionRecipe(String group, @Nullable CraftingBookCategory category, boolean showObtainNotification, NonNullList<Ingredient> ingredients, Ingredient input, ItemStack output) {
        this(new RecipeUtil.RecipeBookDetails(group, category, showObtainNotification), ingredients, input, output);
    }

    public InfusionRecipe(RecipeUtil.RecipeBookDetails recipeBookDetails, NonNullList<Ingredient> ingredients, Ingredient input, ItemStack output) {
        this(recipeBookDetails, ingredients, input, output, ingredients.stream().allMatch(Ingredient::isSimple));
    }

    public ItemStack getToastSymbol() {
        return AoABlocks.INFUSION_TABLE.toStack();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.getIngredients().size() + 1;
    }

    public RecipeSerializer<InfusionRecipe> getSerializer() {
        return (RecipeSerializer)AoARecipes.INFUSION.serializer().get();
    }

    public RecipeType<InfusionRecipe> getType() {
        return (RecipeType)AoARecipes.INFUSION.type().get();
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public boolean matches(GenericRecipeInput inventory, Level level) {
        ItemStack inputStack = inventory.getItem(0);
        if (inputStack.isEmpty() || !this.input.test(inputStack)) {
            return false;
        }
        NonNullList<Ingredient> ingredients = this.getIngredients();
        return this.isSimple ? this.checkSimpleIngredients(inventory, ingredients.size(), inputStack) : this.checkNonSimpleIngredients(inventory, (List<Ingredient>)ingredients, inputStack);
    }

    private boolean checkSimpleIngredients(GenericRecipeInput inventory, int ingredientsCount, ItemStack inputStack) {
        StackedContents itemHelper = new StackedContents();
        for (ItemStack ingredient : inventory.inputs()) {
            if (ingredient.isEmpty() || ingredient == inputStack) continue;
            if (ingredientsCount-- < 0) {
                return false;
            }
            itemHelper.accountStack(ingredient, 1);
        }
        return ingredientsCount == 0 && itemHelper.canCraft((Recipe)this, null);
    }

    private boolean checkNonSimpleIngredients(GenericRecipeInput inventory, List<Ingredient> ingredients, ItemStack inputStack) {
        int ingredientsCount = ingredients.size();
        ObjectArrayList foundIngredients = new ObjectArrayList(ingredientsCount);
        for (ItemStack ingredient : inventory.inputs()) {
            if (ingredient.isEmpty() || ingredient == inputStack) continue;
            if (ingredientsCount-- < 0) {
                return false;
            }
            foundIngredients.add(ingredient);
        }
        return ingredientsCount == 0 && RecipeMatcher.findMatches((List)foundIngredients, ingredients) != null;
    }

    public NonNullList<ItemStack> getRemainingItems(GenericRecipeInput inv) {
        NonNullList returns = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < returns.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (!stack.hasCraftingRemainingItem()) continue;
            returns.set(i, (Object)CommonHooks.getCraftingRemainingItem((ItemStack)stack));
        }
        return returns;
    }

    public ItemStack assemble(GenericRecipeInput inv, HolderLookup.Provider holderLookup) {
        return this.getResultItem(holderLookup);
    }

    public ItemStack getResultItem(HolderLookup.Provider holderLookup) {
        return this.output.copy();
    }

    public static class Factory
    implements RecipeSerializer<InfusionRecipe> {
        public static final MapCodec<InfusionRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> RecipeUtil.RecipeBookDetails.codec(builder, InfusionRecipe::recipeBookDetails).and(builder.group(RecipeUtil.shapelessIngredientCodec("Infusion", InfusionRecipe::ingredients), (App)Ingredient.CODEC_NONEMPTY.fieldOf("base").forGetter(InfusionRecipe::input), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(InfusionRecipe::output))).apply((Applicative)builder, InfusionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, InfusionRecipe> STREAM_CODEC = StreamCodec.composite(RecipeUtil.RecipeBookDetails.STREAM_CODEC, InfusionRecipe::recipeBookDetails, CodecUtil.streamNonNullList(Ingredient.CONTENTS_STREAM_CODEC, Ingredient.EMPTY), InfusionRecipe::ingredients, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, InfusionRecipe::input, (StreamCodec)ItemStack.STREAM_CODEC, InfusionRecipe::output, InfusionRecipe::new);

        public MapCodec<InfusionRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, InfusionRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

