/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.recipe;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.content.block.functional.misc.TrophyBlock;
import net.tslat.aoa3.content.recipe.RecipeBookRecipe;
import net.tslat.aoa3.util.RecipeUtil;

public class GoldTrophyRecipe
extends CustomRecipe
implements RecipeBookRecipe<CraftingInput> {
    private final RecipeUtil.RecipeBookDetails recipeBookDetails;
    private final NonNullList<Ingredient> ingredients = NonNullList.withSize((int)9, (Object)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AoABlocks.TROPHY.get()}));

    public GoldTrophyRecipe(String group, CraftingBookCategory category, boolean showObtainNotification) {
        this(new RecipeUtil.RecipeBookDetails(group, category, showObtainNotification));
    }

    public GoldTrophyRecipe(RecipeUtil.RecipeBookDetails recipeBookDetails) {
        super(recipeBookDetails.category());
        this.recipeBookDetails = recipeBookDetails;
    }

    @Override
    public RecipeUtil.RecipeBookDetails recipeBookDetails() {
        return this.recipeBookDetails;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AoARecipes.GOLD_TROPHY.serializer().get();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean matches(CraftingInput input, Level worldIn) {
        if (input.ingredientCount() != 9) {
            return false;
        }
        String entityType = null;
        for (ItemStack stack : input.items()) {
            String entityId;
            if (stack.getItem() != ((Block)AoABlocks.TROPHY.get()).asItem()) {
                return false;
            }
            TrophyBlock.TrophyData trophyData = (TrophyBlock.TrophyData)stack.get(AoADataComponents.TROPHY_DATA);
            if (trophyData == null || !trophyData.isOriginalTrophy() || (entityId = trophyData.entityData().getString("id")).isEmpty()) {
                return false;
            }
            if (entityType == null) {
                if (trophyData.getEntityType() == null) {
                    return false;
                }
                entityType = entityId;
                continue;
            }
            if (entityType.equals(entityId)) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider holderLookup) {
        for (int i = 0; i < inv.size(); ++i) {
            if (inv.getItem(i).getItem() != ((Block)AoABlocks.TROPHY.get()).asItem()) continue;
            return TrophyBlock.cloneTrophy(inv.getItem(i), (ItemLike)AoABlocks.GOLD_TROPHY.get());
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getResultItem(HolderLookup.Provider holderLookup) {
        return new ItemStack((ItemLike)AoABlocks.GOLD_TROPHY.get());
    }

    public static class Factory
    implements RecipeSerializer<GoldTrophyRecipe> {
        public static final MapCodec<GoldTrophyRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> RecipeUtil.RecipeBookDetails.codec(builder, GoldTrophyRecipe::recipeBookDetails).apply((Applicative)builder, GoldTrophyRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, GoldTrophyRecipe> STREAM_CODEC = StreamCodec.composite(RecipeUtil.RecipeBookDetails.STREAM_CODEC, GoldTrophyRecipe::recipeBookDetails, GoldTrophyRecipe::new);

        public MapCodec<GoldTrophyRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, GoldTrophyRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

