/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.recipe;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.recipe.RecipeBookRecipe;
import net.tslat.aoa3.util.RecipeUtil;

public record FrameBenchRecipe(RecipeUtil.RecipeBookDetails recipeBookDetails, Ingredient input, ItemStack output) implements RecipeBookRecipe<SingleRecipeInput>
{
    private static final RecipeType<FrameBenchRecipe> RECIPE_TYPE = new RecipeType<FrameBenchRecipe>(){

        public String toString() {
            return "frame_bench";
        }
    };

    public FrameBenchRecipe(ItemLike output) {
        this(new RecipeUtil.RecipeBookDetails("", CraftingBookCategory.EQUIPMENT, false), Ingredient.of((ItemLike[])new ItemLike[]{AoAItems.SCRAP_METAL}), output.asItem().getDefaultInstance());
    }

    public ItemStack getToastSymbol() {
        return AoABlocks.FRAME_BENCH.toStack();
    }

    public boolean matches(SingleRecipeInput inv, Level world) {
        return this.input.test(inv.getItem(0));
    }

    public ItemStack assemble(SingleRecipeInput inv, HolderLookup.Provider holderLookup) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height == 1;
    }

    public ItemStack getResultItem(HolderLookup.Provider holderLookup) {
        return this.output.copy();
    }

    public RecipeSerializer<FrameBenchRecipe> getSerializer() {
        return null;
    }

    public RecipeType<FrameBenchRecipe> getType() {
        return RECIPE_TYPE;
    }

    public NonNullList<ItemStack> getRemainingItems(SingleRecipeInput inv) {
        return NonNullList.create();
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.create();
        ingredients.add((Object)this.input);
        return ingredients;
    }
}

