/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.tslat.aoa3.common.registration.AoARegistries;
import org.jetbrains.annotations.NotNull;

public class ReplaceItemsLootModifier
extends LootModifier {
    public static final MapCodec<ReplaceItemsLootModifier> CODEC = RecordCodecBuilder.mapCodec(builder -> ReplaceItemsLootModifier.codecStart((RecordCodecBuilder.Instance)builder).and((App)Codec.pair((Codec)AoARegistries.ITEMS.lookupCodec().fieldOf("item").codec(), (Codec)ItemStack.CODEC.fieldOf("replace_with").codec()).listOf().fieldOf("replacements").forGetter(instance -> instance.replacements)).apply((Applicative)builder, ReplaceItemsLootModifier::new));
    private final List<Pair<Item, ItemStack>> replacements;

    public ReplaceItemsLootModifier(LootItemCondition[] conditions, List<Pair<Item, ItemStack>> replacements) {
        super(conditions);
        this.replacements = replacements;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ObjectArrayList loot = new ObjectArrayList();
        for (ItemStack stack : generatedLoot) {
            for (Pair<Item, ItemStack> pair : this.replacements) {
                loot.add((Object)(stack.is((Item)pair.getFirst()) ? (ItemStack)pair.getSecond() : stack));
            }
        }
        EquipmentSlot[] equipmentSlotArray = context.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (equipmentSlotArray instanceof Mob) {
            Mob mob = (Mob)equipmentSlotArray;
            block2: for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack = mob.getItemBySlot(slot);
                if (stack.isEmpty()) continue;
                for (Pair<Item, ItemStack> pair : this.replacements) {
                    if (!stack.is((Item)pair.getFirst())) continue;
                    mob.setItemSlot(slot, (ItemStack)pair.getSecond());
                    continue block2;
                }
            }
        }
        return loot;
    }
}

