/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.modifier;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.tslat.aoa3.content.item.LootModifyingItem;
import org.jetbrains.annotations.NotNull;

public class LootModifyingItemLootModifier
extends LootModifier {
    public static final MapCodec<LootModifyingItemLootModifier> CODEC = RecordCodecBuilder.mapCodec(builder -> LootModifyingItemLootModifier.codecStart((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, LootModifyingItemLootModifier::new));

    public LootModifyingItemLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        LivingEntity killer;
        Iterator heldItems;
        Entity entity;
        ItemStack tool = ItemStack.EMPTY;
        if (context.hasParam(LootContextParams.TOOL)) {
            tool = (ItemStack)context.getParamOrNull(LootContextParams.TOOL);
            if (tool == null) {
                return generatedLoot;
            }
        } else if (context.hasParam(LootContextParams.ATTACKING_ENTITY) && (entity = (Entity)context.getParamOrNull(LootContextParams.ATTACKING_ENTITY)) instanceof LivingEntity && (heldItems = (killer = (LivingEntity)entity).getHandSlots().iterator()).hasNext()) {
            tool = (ItemStack)heldItems.next();
        }
        if (tool.getItem() instanceof LootModifyingItem) {
            ((LootModifyingItem)tool.getItem()).doLootModification((List<ItemStack>)generatedLoot, context);
        }
        return generatedLoot;
    }
}

