/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.modifier;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ListIterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.common.util.TriState;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.functional.misc.FertilisedFarmland;
import net.tslat.aoa3.util.ItemUtil;
import org.jetbrains.annotations.NotNull;

public class FertilisedFarmlandLootModifier
extends LootModifier {
    public static final MapCodec<FertilisedFarmlandLootModifier> CODEC = RecordCodecBuilder.mapCodec(builder -> FertilisedFarmlandLootModifier.codecStart((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, FertilisedFarmlandLootModifier::new));

    public FertilisedFarmlandLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (generatedLoot.isEmpty()) {
            return generatedLoot;
        }
        BlockState state = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        Vec3 pos = (Vec3)context.getParamOrNull(LootContextParams.ORIGIN);
        if (state != null && pos != null && state.getBlock() instanceof CropBlock && state.getBlock() != AoABlocks.GREEN_MANURE.get()) {
            BlockPos farmlandPos = BlockPos.containing((Position)pos).below();
            BlockState belowBlock = context.getLevel().getBlockState(farmlandPos);
            if (belowBlock.getBlock() instanceof FertilisedFarmland && belowBlock.getBlock().canSustainPlant(belowBlock, (BlockGetter)context.getLevel(), farmlandPos, Direction.UP, state) != TriState.FALSE) {
                int increaseAmount = (Boolean)belowBlock.getValue((Property)FertilisedFarmland.WELL_FERTILISED) != false ? 2 : 1;
                Item seeds = ((CropBlock)state.getBlock()).getCloneItemStack((LevelReader)context.getLevel(), BlockPos.containing((Position)pos), state).getItem();
                ObjectListIterator iterator = generatedLoot.listIterator();
                while (iterator.hasNext()) {
                    ItemStack itStack = (ItemStack)iterator.next();
                    if (itStack.getItem() == seeds) continue;
                    ItemUtil.increaseStackSize(itStack, increaseAmount).forEach(((ListIterator)iterator)::add);
                }
                context.getLevel().setBlock(farmlandPos, (BlockState)(increaseAmount == 2 ? ((Block)AoABlocks.FERTILISED_FARMLAND.get()).defaultBlockState() : Blocks.FARMLAND.defaultBlockState()).setValue((Property)FarmBlock.MOISTURE, (Comparable)((Integer)belowBlock.getValue((Property)FarmBlock.MOISTURE))), 3);
            }
        }
        return generatedLoot;
    }
}

