/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.loot.AoALootConditions;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.PlayerUtil;

public record PlayerHasResource(AoAResource resource, float amount, boolean consume) implements LootItemCondition
{
    public static final MapCodec<PlayerHasResource> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.lazyInitialized(AoARegistries.AOA_RESOURCES::lookupCodec).fieldOf("resource").forGetter(PlayerHasResource::resource), (App)Codec.FLOAT.fieldOf("amount").forGetter(PlayerHasResource::amount), (App)Codec.BOOL.optionalFieldOf("consume", (Object)false).forGetter(PlayerHasResource::consume)).apply((Applicative)builder, PlayerHasResource::new));

    public LootItemConditionType getType() {
        return (LootItemConditionType)AoALootConditions.PLAYER_HAS_RESOURCE.get();
    }

    public static LootItemCondition.Builder forResource(AoAResource resource, float amount) {
        return () -> new PlayerHasResource(resource, amount, false);
    }

    public static LootItemCondition.Builder checkAndConsume(AoAResource resource, float amount) {
        return () -> new PlayerHasResource(resource, amount, true);
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.getParamOrNull(LootContextParams.DIRECT_ATTACKING_ENTITY);
        if (entity == null) {
            entity = (Entity)lootContext.getParamOrNull(LootContextParams.ATTACKING_ENTITY);
        }
        if (entity == null) {
            entity = (Entity)lootContext.getParamOrNull(LootContextParams.THIS_ENTITY);
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            return this.consume ? PlayerUtil.consumeResource(pl, this.resource, this.amount, false) : PlayerUtil.getResourceValue((Player)pl, this.resource) >= this.amount;
        }
        return false;
    }
}

