/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.loot.AoALootConditions;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;

public record PlayerHasLevel(AoASkill skill, int level) implements LootItemCondition
{
    public static final MapCodec<PlayerHasLevel> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.lazyInitialized(AoARegistries.AOA_SKILLS::lookupCodec).fieldOf("skill").forGetter(PlayerHasLevel::skill), (App)Codec.intRange((int)1, (int)1000).fieldOf("level").forGetter(PlayerHasLevel::level)).apply((Applicative)builder, PlayerHasLevel::new));

    public LootItemConditionType getType() {
        return (LootItemConditionType)AoALootConditions.PLAYER_HAS_LEVEL.get();
    }

    public static LootItemCondition.Builder forSkill(AoASkill skill, int level) {
        return () -> new PlayerHasLevel(skill, level);
    }

    public boolean test(LootContext lootContext) {
        ServerPlayer pl;
        Entity entity = (Entity)lootContext.getParamOrNull(LootContextParams.DIRECT_ATTACKING_ENTITY);
        if (entity == null) {
            entity = (Entity)lootContext.getParamOrNull(LootContextParams.ATTACKING_ENTITY);
        }
        if (entity == null) {
            entity = (Entity)lootContext.getParamOrNull(LootContextParams.THIS_ENTITY);
        }
        return entity instanceof ServerPlayer && PlayerUtil.doesPlayerHaveLevel((Player)(pl = (ServerPlayer)entity), this.skill, this.level);
    }
}

