/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.tslat.aoa3.common.registration.loot.AoALootConditions;

public record BlockHasTag(List<TagKey<Block>> tags, boolean requireAll) implements LootItemCondition
{
    public static final MapCodec<BlockHasTag> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)TagKey.codec((ResourceKey)Registries.BLOCK).listOf().fieldOf("tags").forGetter(BlockHasTag::tags), (App)Codec.BOOL.optionalFieldOf("require_all", (Object)false).forGetter(BlockHasTag::requireAll)).apply((Applicative)builder, BlockHasTag::new));

    public LootItemConditionType getType() {
        return (LootItemConditionType)AoALootConditions.HAS_BLOCK_TAG.get();
    }

    public static LootItemCondition.Builder forAny(TagKey<Block> ... tags) {
        return () -> new BlockHasTag(List.of(tags), false);
    }

    public static LootItemCondition.Builder forAll(TagKey<Block> ... tags) {
        return () -> new BlockHasTag(List.of(tags), true);
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Set.of(LootContextParams.BLOCK_STATE);
    }

    public boolean test(LootContext lootContext) {
        BlockState state = (BlockState)lootContext.getParamOrNull(LootContextParams.BLOCK_STATE);
        if (state == null) {
            return false;
        }
        if (this.requireAll) {
            for (TagKey<Block> tag : this.tags) {
                if (state.is(tag)) continue;
                return false;
            }
            return true;
        }
        for (TagKey<Block> tag : this.tags) {
            if (!state.is(tag)) continue;
            return true;
        }
        return false;
    }
}

