/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.sword;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.content.item.weapon.sword.BaseSword;
import net.tslat.aoa3.util.LocaleUtil;

public class TrollBasherAxe
extends BaseSword {
    public TrollBasherAxe(Tier tier, Item.Properties properties) {
        super(tier, properties, TrollBasherAxe.createToolProperties(tier, (TagKey<Block>)BlockTags.MINEABLE_WITH_AXE));
    }

    public static Tool createToolProperties(Tier tier, TagKey<Block> toolMineableTag) {
        Tool tierDefaults = tier.createToolProperties(toolMineableTag);
        ObjectArrayList rules = new ObjectArrayList((Collection)tierDefaults.rules());
        rules.addAll(List.of(Tool.Rule.minesAndDrops(List.of(Blocks.COBWEB), (float)15.0f), Tool.Rule.overrideSpeed((TagKey)BlockTags.SWORD_EFFICIENT, (float)1.5f)));
        return new Tool(List.copyOf(rules), 1.0f, 2);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        Tool tool = (Tool)stack.get(DataComponents.TOOL);
        if (tool == null) {
            return false;
        }
        if (!level.isClientSide && state.getDestroySpeed((BlockGetter)level, pos) != 0.0f && tool.damagePerBlock() > 0) {
            stack.hurtAndBreak(((Tool)stack.get(DataComponents.TOOL)).isCorrectForDrops(state) ? 1 : tool.damagePerBlock(), miningEntity, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
    }
}

