/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.sword;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.sword.BaseSword;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class RunicSword
extends BaseSword {
    public RunicSword(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    @Override
    public float getDamageForAttack(LivingEntity target, LivingEntity attacker, ItemStack swordStack, DamageSource source, float baseDamage) {
        ItemStack offhandStack;
        if (baseDamage / this.getBaseDamage(swordStack) > 0.75f && (offhandStack = attacker.getOffhandItem()).getItem() == AoAItems.FIRE_RUNE.get() && offhandStack.getCount() >= 5) {
            target.igniteForSeconds(5.0f);
        }
        return super.getDamageForAttack(target, attacker, swordStack, source, baseDamage);
    }

    @Override
    protected void doMeleeEffect(ItemStack stack, LivingEntity target, LivingEntity attacker, float attackCooldown) {
        ItemStack offhandStack;
        if (!attacker.level().isClientSide && (double)attackCooldown > 0.75 && (offhandStack = attacker.getOffhandItem()).is(AoATags.Items.ADVENT_RUNE) && offhandStack.getCount() >= 5) {
            Item rune = offhandStack.getItem();
            if (rune == AoAItems.POISON_RUNE.get()) {
                target.addEffect(new MobEffectInstance(MobEffects.POISON, 72, 1, false, true));
            } else if (rune == AoAItems.WITHER_RUNE.get()) {
                target.addEffect(new MobEffectInstance(MobEffects.WITHER, 40, 2, false, true));
            } else if (rune == AoAItems.WIND_RUNE.get()) {
                DamageUtil.doScaledKnockback(target, attacker, 0.5f, 1.0, 1.0, 1.0);
            } else if (rune == AoAItems.WATER_RUNE.get()) {
                target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 0, false, true));
            } else if (rune == AoAItems.CHARGED_RUNE.get()) {
                ((ServerLevel)target.level()).sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, target.getX() + (double)(RandomUtil.randomValueUpTo((float)1.0f) * target.getBbWidth() * 2.0f) - (double)target.getBbWidth(), target.getY() + 1.0 + (double)(RandomUtil.randomValueUpTo((float)1.0f) * target.getBbHeight()), target.getZ() + (double)(RandomUtil.randomValueUpTo((float)1.0f) * target.getBbWidth() * 2.0f) - (double)target.getBbWidth(), 3, 0.0, 0.0, 0.0, 0.0);
            } else if (rune != AoAItems.FIRE_RUNE.get()) {
                return;
            }
            if (attacker instanceof Player) {
                Player pl = (Player)attacker;
                if (!pl.getAbilities().instabuild) {
                    offhandStack.shrink(5);
                    ItemUtil.damageItemForUser(pl, stack, EquipmentSlot.MAINHAND);
                }
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.HARMFUL, 2, new Component[0]));
    }
}

