/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.sword;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.content.item.weapon.sword.BaseSword;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class RosidianSword
extends BaseSword {
    public RosidianSword(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity target) {
        stack.set(AoADataComponents.MELEE_SWING_STRENGTH, (Object)Float.valueOf(player.getAttackStrengthScale(0.0f)));
        if (player.getHealth() < player.getMaxHealth()) {
            float motionX = (float)(player.getX() - target.getX()) * 0.1f;
            float motionY = (float)(player.getY() - target.getY()) * 0.1f;
            float motionZ = (float)(player.getZ() - target.getZ()) * 0.1f;
            player.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, target.getX() + RandomUtil.randomScaledGaussianValue((double)0.2), target.getY() + (double)(target.getBbHeight() / 2.0f), target.getZ() + RandomUtil.randomScaledGaussianValue((double)0.2), (double)motionX, (double)motionY, (double)motionZ);
            for (LivingEntity swipeTarget : player.level().getEntitiesOfClass(LivingEntity.class, target.getBoundingBox().inflate(1.0, 0.25, 1.0))) {
                if (swipeTarget == target || swipeTarget == player || player.isAlliedTo((Entity)swipeTarget) || !(player.distanceToSqr((Entity)swipeTarget) < 9.0)) continue;
                motionX = (float)(player.getX() - swipeTarget.getX()) * 0.1f;
                motionY = (float)(player.getY() - swipeTarget.getY()) * 0.1f;
                motionZ = (float)(player.getZ() - swipeTarget.getZ()) * 0.1f;
                player.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, true, swipeTarget.getX() + RandomUtil.randomScaledGaussianValue((double)0.2), swipeTarget.getY() + (double)(target.getBbHeight() / 2.0f), swipeTarget.getZ() + RandomUtil.randomScaledGaussianValue((double)0.2), (double)motionX, (double)motionY, (double)motionZ);
            }
        }
        return false;
    }

    @Override
    protected void doMeleeEffect(ItemStack stack, LivingEntity target, LivingEntity attacker, float attackCooldown) {
        if (attacker.getHealth() < attacker.getMaxHealth() && attackCooldown == 1.0f) {
            EntityUtil.healEntity(attacker, 1.0f);
            if (attacker instanceof Player) {
                for (LivingEntity swipeTarget : attacker.level().getEntitiesOfClass(LivingEntity.class, target.getBoundingBox().inflate(1.0, 0.25, 1.0))) {
                    if (swipeTarget == target || swipeTarget == attacker || !(swipeTarget.getHealth() < swipeTarget.getMaxHealth()) || attacker.isAlliedTo((Entity)swipeTarget) || !(attacker.distanceToSqr((Entity)swipeTarget) < 9.0)) continue;
                    EntityUtil.healEntity(attacker, 0.4f);
                }
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
    }
}

