/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.sword;

import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.content.item.weapon.sword.BaseSword;
import net.tslat.aoa3.util.LocaleUtil;

public class PrimalSword
extends BaseSword {
    public PrimalSword(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean isSelected) {
        if (world.getGameTime() % 10L == 0L && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            float damageScaling = ((Float)stack.getOrDefault(AoADataComponents.DAMAGE_SCALING, (Object)Float.valueOf(0.0f))).floatValue();
            if (isSelected) {
                float currentCalcBuff = this.getCurrentDamageBuff(entity);
                if (damageScaling != currentCalcBuff) {
                    stack.set(AoADataComponents.DAMAGE_SCALING, (Object)Float.valueOf(currentCalcBuff));
                    stack.update(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY, modifiers -> modifiers.withModifierAdded(Attributes.ATTACK_DAMAGE, this.getAttackDamageModifier(stack), EquipmentSlotGroup.MAINHAND));
                }
            } else if (damageScaling != 0.0f && livingEntity.getMainHandItem().isEmpty()) {
                stack.update(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY, modifiers -> modifiers.withModifierAdded(Attributes.ATTACK_DAMAGE, this.getAttackDamageModifier(stack), EquipmentSlotGroup.MAINHAND));
                stack.set(AoADataComponents.DAMAGE_SCALING, (Object)Float.valueOf(0.0f));
            }
        }
    }

    private float getCurrentDamageBuff(Entity holder) {
        LivingEntity entity;
        if (!(holder instanceof LivingEntity) || !(entity = (LivingEntity)holder).getAttributes().hasAttribute(Attributes.ARMOR)) {
            return 1.0f;
        }
        float armour = (float)entity.getAttributeValue(Attributes.ARMOR);
        if (armour > 15.0f) {
            return 15.0f / armour;
        }
        return 1.5f - armour / 30.0f;
    }

    protected AttributeModifier getAttackDamageModifier(ItemStack stack) {
        float damageScaling = ((Float)stack.getOrDefault(AoADataComponents.DAMAGE_SCALING, (Object)Float.valueOf(0.0f))).floatValue();
        return new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)(this.getTier().getAttackDamageBonus() * (damageScaling == 0.0f ? 1.0f : damageScaling)), AttributeModifier.Operation.ADD_VALUE);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
    }
}

