/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.sword;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.content.item.weapon.sword.BaseSword;
import net.tslat.aoa3.util.LocaleUtil;

public class NethengeicSword
extends BaseSword {
    public NethengeicSword(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    @Override
    public float getDamageForAttack(LivingEntity target, LivingEntity attacker, ItemStack swordStack, DamageSource source, float baseDamage) {
        if (baseDamage > 0.0f && !attacker.level().isClientSide && !target.fireImmune() && !target.isInvulnerableTo(target.level().damageSources().onFire())) {
            target.igniteForSeconds((float)((int)(4.0f * baseDamage / this.getBaseDamage(swordStack))));
        }
        return super.getDamageForAttack(target, attacker, swordStack, source, baseDamage);
    }

    @Override
    protected void doMeleeEffect(ItemStack stack, LivingEntity target, LivingEntity attacker, float attackCooldown) {
        if (!attacker.level().isClientSide && (target.fireImmune() || target.isInvulnerableTo(target.level().damageSources().onFire()))) {
            target.addEffect(new MobEffectInstance(MobEffects.WITHER, (int)(80.0f * attackCooldown), 2, false, true));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.BURNS_TARGETS, LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
    }
}

