/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.sword;

import java.util.Iterator;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.content.item.weapon.sword.BaseSword;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.RandomUtil;

public class IllusionSword
extends BaseSword {
    public IllusionSword(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    @Override
    protected void doMeleeEffect(ItemStack stack, LivingEntity target, LivingEntity attacker, float attackCooldown) {
        List nearbyMobs;
        if (!attacker.level().isClientSide && !EntityUtil.isImmuneToSpecialAttacks((Entity)target) && RandomUtil.percentChance((float)(0.1f * attackCooldown)) && (nearbyMobs = target.level().getEntitiesOfClass(LivingEntity.class, target.getBoundingBox().inflate(5.0), EntityUtil::isHostileMob)).size() > 1) {
            LivingEntity nearbyMob;
            LivingEntity newTarget = null;
            Iterator iterator = nearbyMobs.iterator();
            while (iterator.hasNext() && (newTarget = (nearbyMob = (LivingEntity)iterator.next())) == target) {
            }
            if (newTarget == null) {
                return;
            }
            target.setLastHurtByMob(newTarget);
            BrainUtils.setTargetOfEntity((LivingEntity)target, (LivingEntity)newTarget);
            target.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 60, 0, false, true));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
    }
}

