/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.sword;

import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.ChargeableItem;
import net.tslat.aoa3.content.item.weapon.sword.BaseSword;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class GuardiansSword
extends BaseSword
implements ChargeableItem {
    public GuardiansSword(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (this.getCharge(heldStack) <= 0.0f && InventoryUtil.findItemForConsumption(player, AoAItems.CRYSTALLITE, player.getAbilities().instabuild ? 0 : 1, true)) {
            this.setCharge(heldStack, level.getGameTime() + 2400L);
            heldStack.update(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY, modifiers -> modifiers.withModifierAdded(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)(3.0f + this.getTier().getAttackDamageBonus()), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                double xOffset = -Mth.sin((float)(player.getYRot() * (float)Math.PI / 140.0f));
                double zOffset = Mth.cos((float)(player.getYRot() * (float)Math.PI / 140.0f));
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, player.getX() + xOffset, player.getY() + (double)player.getBbHeight() * 0.5, player.getZ() + zOffset, 5, xOffset, 0.0, zOffset, 0.0);
            }
            return InteractionResultHolder.success((Object)heldStack);
        }
        return super.use(level, player, hand);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        float charge;
        if (level.getGameTime() % 10L == 0L && (charge = this.getCharge(stack)) > 0.0f && charge < (float)level.getGameTime()) {
            this.setCharge(stack, 0.0f);
            stack.update(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY, modifiers -> modifiers.withModifierAdded(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)this.getTier().getAttackDamageBonus(), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
        }
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ItemUtil.damageItemForUser(level2, stack, attacker, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
    }
}

