/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.sword;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.tslat.aoa3.content.item.LootModifyingItem;
import net.tslat.aoa3.content.item.weapon.sword.BaseSword;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;

public class EmberstoneSword
extends BaseSword
implements LootModifyingItem {
    public EmberstoneSword(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    @Override
    public void doLootModification(List<ItemStack> existingLoot, LootContext lootContext) {
        if (!this.isEntityKillLoot(lootContext)) {
            return;
        }
        ServerLevel level = lootContext.getLevel();
        Entity entity = (Entity)lootContext.getParam(LootContextParams.THIS_ENTITY);
        int i = 0;
        while (i < existingLoot.size()) {
            ItemStack lootStack = existingLoot.get(i);
            Optional smeltRecipe = level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(lootStack), (Level)level);
            int stackIndex = i++;
            smeltRecipe.ifPresent(holder -> {
                existingLoot.set(stackIndex, ((SmeltingRecipe)((RecipeHolder)smeltRecipe.get()).value()).getResultItem((HolderLookup.Provider)lootContext.getLevel().registryAccess()));
                ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.FLAME, (Entity)entity).spawnNTimes(5).sendToAllPlayersTrackingEntity(level, entity);
            });
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
    }
}

