/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.LocaleUtil;
import org.jetbrains.annotations.Nullable;

public class SkyStaff
extends BaseStaff<Boolean> {
    public SkyStaff(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_SKY_STAFF_CAST.get();
    }

    public static Object2IntMap<Item> getDefaultRunes() {
        return (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), runes -> {
            runes.put((Object)((Item)AoAItems.WIND_RUNE.get()), 2);
            runes.put((Object)((Item)AoAItems.KINETIC_RUNE.get()), 2);
            runes.put((Object)((Item)AoAItems.ENERGY_RUNE.get()), 1);
        });
    }

    @Override
    public Optional<Boolean> checkPreconditions(LivingEntity caster, ItemStack staff) {
        return Optional.ofNullable(caster.onGround() ? Boolean.valueOf(true) : null);
    }

    @Override
    public void cast(ServerLevel level, ItemStack staff, LivingEntity caster, Boolean args) {
        caster.setSprinting(true);
        double xMotion = -Mth.sin((float)(caster.getYRot() / 180.0f * (float)Math.PI)) * Mth.cos((float)(caster.getXRot() / 180.0f * (float)Math.PI)) * 2.0f;
        double zMotion = Mth.cos((float)(caster.getYRot() / 180.0f * (float)Math.PI)) * Mth.cos((float)(caster.getXRot() / 180.0f * (float)Math.PI)) * 2.0f;
        double yMotion = caster.getDeltaMovement().y();
        yMotion = Math.abs(xMotion) < 0.4 && Math.abs(zMotion) < 0.4 ? (yMotion += 2.0) : (yMotion += 0.75);
        caster.setDeltaMovement(new Vec3(xMotion, yMotion, zMotion));
        caster.hurtMarked = true;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 2, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

