/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.entity.projectile.staff.ShyreShotEntity;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.event.custom.AoAEvents;
import net.tslat.aoa3.event.custom.events.MagicTeleportEvent;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;
import org.jetbrains.annotations.Nullable;

public class ShyreStaff
extends BaseStaff<Object> {
    public ShyreStaff(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_SHYRE_STAFF_CAST.get();
    }

    public static Object2IntMap<Item> getDefaultRunes() {
        return (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), runes -> {
            runes.put((Object)((Item)AoAItems.ENERGY_RUNE.get()), 3);
            runes.put((Object)((Item)AoAItems.DISTORTION_RUNE.get()), 3);
        });
    }

    @Override
    public void cast(ServerLevel level, ItemStack staff, LivingEntity caster, Object args) {
        level.addFreshEntity((Entity)new ShyreShotEntity(caster, this, 120));
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, Vec3 hitPos, LivingEntity shooter) {
        Level world = shooter.level();
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos(hitPos.x(), hitPos.y(), hitPos.z());
        BlockState state = world.getBlockState((BlockPos)testPos);
        Vec3 shotMotion = shot.getDeltaMovement();
        Vec3 testVec = hitPos;
        for (int tests = 0; tests <= 10 && !(state = world.getBlockState((BlockPos)testPos)).isAir(); ++tests) {
            testVec = testVec.subtract(shotMotion.x() * (double)0.15f, shotMotion.y() * (double)0.15f, shotMotion.z() * (double)0.15f);
            testPos.set(testVec.x() + (double)shooter.getBbWidth(), testVec.y(), testVec.z() + (double)shooter.getBbWidth());
        }
        if (state.isAir()) {
            MagicTeleportEvent event = AoAEvents.fireMagicalTeleport((Entity)shooter, null, null, testVec);
            if (event.isCanceled()) {
                return;
            }
            testVec = event.getTarget();
        }
        shooter.teleportTo(testVec.x(), testVec.y(), testVec.z());
        if (shooter instanceof ServerPlayer && WorldUtil.isWorld(shooter.level(), AoADimensions.LUNALUS)) {
            AdvancementUtil.grantCriterion((ServerPlayer)shooter, AdventOfAscension.id("lunalus/200_iq"), "lunalus_shyre_staff_travel");
        }
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        MagicTeleportEvent event = AoAEvents.fireMagicalTeleport((Entity)shooter, null, null, new Vec3((target.getX() + shot.getX()) / 2.0, (target.getY() + shot.getY()) / 2.0, (target.getZ() + shot.getZ()) / 2.0));
        if (event.isCanceled()) {
            return false;
        }
        shooter.teleportTo(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        return true;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

