/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.LocaleUtil;
import org.jetbrains.annotations.Nullable;

public class RunicStaff
extends BaseStaff<PlayerEnderChestContainer> {
    public RunicStaff(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_RUNIC_STAFF_CAST.get();
    }

    public static Object2IntMap<Item> getDefaultRunes() {
        return (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), runes -> runes.put((Object)((Item)AoAItems.DISTORTION_RUNE.get()), 5));
    }

    @Override
    public Optional<PlayerEnderChestContainer> checkPreconditions(LivingEntity caster, ItemStack staff) {
        PlayerEnderChestContainer playerEnderChestContainer;
        if (caster instanceof Player) {
            Player pl = (Player)caster;
            playerEnderChestContainer = pl.getEnderChestInventory();
        } else {
            playerEnderChestContainer = null;
        }
        return Optional.ofNullable(playerEnderChestContainer);
    }

    @Override
    public void cast(ServerLevel level, ItemStack staff, LivingEntity caster, PlayerEnderChestContainer args) {
        ((Player)caster).openMenu((MenuProvider)new SimpleMenuProvider((id, player, inventory) -> ChestMenu.threeRows((int)id, (Inventory)player, (Container)args), (Component)Component.translatable((String)"container.enderchest")));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

