/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.entity.projectile.staff.RosidianShotEntity;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import org.jetbrains.annotations.Nullable;

public class RosidianStaff
extends BaseStaff<Object> {
    public RosidianStaff(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_STAFF_CAST.get();
    }

    public static Object2IntMap<Item> getDefaultRunes() {
        return (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), runes -> {
            runes.put((Object)((Item)AoAItems.WIND_RUNE.get()), 3);
            runes.put((Object)((Item)AoAItems.WATER_RUNE.get()), 2);
            runes.put((Object)((Item)AoAItems.LIFE_RUNE.get()), 1);
        });
    }

    @Override
    public void cast(ServerLevel level, ItemStack staff, LivingEntity caster, Object args) {
        level.addFreshEntity((Entity)new RosidianShotEntity(caster, this));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (DamageUtil.doMagicProjectileAttack((Entity)shooter, (Entity)shot, target, this.getDmg())) {
            EntityUtil.healEntity(shooter, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public float getDmg() {
        return 21.0f;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 2, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

