/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;
import org.jetbrains.annotations.Nullable;

public class NatureStaff
extends BaseStaff<List<BlockPos>> {
    public NatureStaff(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_NATURE_STAFF_CAST.get();
    }

    @Override
    public Optional<List<BlockPos>> checkPreconditions(LivingEntity caster, ItemStack staff) {
        List<BlockPos> blocks = WorldUtil.getBlocksWithinAABB(caster.level(), caster.getBoundingBox().inflate(10.0), (state, pos) -> {
            Block patt0$temp = state.getBlock();
            if (!(patt0$temp instanceof BonemealableBlock)) {
                return false;
            }
            BonemealableBlock bonemealable = (BonemealableBlock)patt0$temp;
            if (!bonemealable.isValidBonemealTarget((LevelReader)caster.level(), pos.immutable(), state)) {
                return false;
            }
            return WorldUtil.canModifyBlock((LevelAccessor)caster.level(), (BlockPos)pos, (Entity)caster, staff);
        });
        return Optional.ofNullable(blocks.isEmpty() ? null : blocks);
    }

    public static Object2IntMap<Item> getDefaultRunes() {
        return (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), runes -> {
            runes.put((Object)((Item)AoAItems.LIFE_RUNE.get()), 4);
            runes.put((Object)((Item)AoAItems.ENERGY_RUNE.get()), 2);
        });
    }

    @Override
    public void cast(ServerLevel level, ItemStack staff, LivingEntity caster, List<BlockPos> args) {
        for (BlockPos pos : args) {
            BoneMealItem.growCrop((ItemStack)new ItemStack((ItemLike)Items.BONE_MEAL), (Level)caster.level(), (BlockPos)pos);
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

