/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.entity.projectile.staff.MoonlightFallEntity;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import org.jetbrains.annotations.Nullable;

public class MoonlightStaff
extends BaseStaff<BlockPos> {
    public MoonlightStaff(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_MOONLIGHT_STAFF_CAST.get();
    }

    public static Object2IntMap<Item> getDefaultRunes() {
        return (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), runes -> {
            runes.put((Object)((Item)AoAItems.COMPASS_RUNE.get()), 1);
            runes.put((Object)((Item)AoAItems.LUNAR_RUNE.get()), 2);
            runes.put((Object)((Item)AoAItems.KINETIC_RUNE.get()), 2);
        });
    }

    @Override
    public Optional<BlockPos> checkPreconditions(LivingEntity caster, ItemStack staff) {
        return Optional.ofNullable(PlayerUtil.getBlockAimingAt(caster, 70.0));
    }

    @Override
    public void cast(ServerLevel level, ItemStack staff, LivingEntity caster, BlockPos args) {
        level.addFreshEntity((Entity)new MoonlightFallEntity(caster, this, args.getX(), args.getY() + 30, args.getZ(), 3.0f));
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, Vec3 hitPos, LivingEntity caster) {
        this.createCloud(shot, caster);
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity caster) {
        if (!target.isInvulnerable()) {
            this.createCloud(shot, caster);
            return true;
        }
        return false;
    }

    private void createCloud(BaseEnergyShot shot, LivingEntity caster) {
        AreaEffectCloud cloud = new AreaEffectCloud(shot.level(), shot.getX(), shot.getY(), shot.getZ());
        cloud.setOwner(caster);
        cloud.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 140, 1, false, true));
        cloud.setRadius(0.1f);
        cloud.setRadiusPerTick(1.0f);
        cloud.setDuration(10);
        cloud.setWaitTime(0);
        shot.level().addFreshEntity((Entity)cloud);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

