/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.AABB;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.entity.projectile.staff.LyonicShotEntity;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public class MechaStaff
extends BaseStaff<Object> {
    private static final AttributeModifier DEBUFF = new AttributeModifier(AdventOfAscension.id("mecha_staff_debuff"), -0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);

    public MechaStaff(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_STAFF_CAST.get();
    }

    public static Object2IntMap<Item> getDefaultRunes() {
        return (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), runes -> {
            runes.put((Object)((Item)AoAItems.WIND_RUNE.get()), 2);
            runes.put((Object)((Item)AoAItems.DISTORTION_RUNE.get()), 1);
            runes.put((Object)((Item)AoAItems.POWER_RUNE.get()), 1);
        });
    }

    @Override
    public void cast(ServerLevel level, ItemStack staff, LivingEntity caster, Object args) {
        level.addFreshEntity((Entity)new LyonicShotEntity(caster, this, 60));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (target instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)target;
            if (!entity.level().isClientSide && AttributeUtil.getAttribute(entity, (Holder<Attribute>)Attributes.ARMOR).filter(instance -> instance.getValue() > 0.0 && !instance.hasModifier(DEBUFF.id())).isPresent()) {
                AttributeUtil.applyTransientModifier(entity, (Holder<Attribute>)Attributes.ARMOR, DEBUFF);
                AABB bounds = entity.getBoundingBox();
                for (int i = 0; i < 8; ++i) {
                    ((ServerLevel)entity.level()).sendParticles((ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING, bounds.minX + (double)RandomUtil.randomValueUpTo((float)entity.getBbWidth()), bounds.maxY + 0.1, bounds.minZ + (double)RandomUtil.randomValueUpTo((float)entity.getBbWidth()), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

