/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;

public class CrystikStaff
extends BaseStaff<List<LivingEntity>> {
    public CrystikStaff(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_CRYSTEVIA_STAFF_CAST.get();
    }

    @Override
    public Optional<List<LivingEntity>> checkPreconditions(LivingEntity caster, ItemStack staff) {
        List targets = EntityRetrievalUtil.getEntities((Entity)caster, (double)10.0, entity -> {
            LivingEntity livingEntity;
            return entity instanceof LivingEntity && EntityUtil.isHostileMob((Entity)(livingEntity = (LivingEntity)entity));
        });
        return Optional.ofNullable(targets.isEmpty() ? null : targets);
    }

    public static Object2IntMap<Item> getDefaultRunes() {
        return (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), runes -> {
            runes.put((Object)((Item)AoAItems.DISTORTION_RUNE.get()), 2);
            runes.put((Object)((Item)AoAItems.LIFE_RUNE.get()), 1);
            runes.put((Object)((Item)AoAItems.WATER_RUNE.get()), 1);
        });
    }

    @Override
    public void cast(ServerLevel level, ItemStack staff, LivingEntity caster, List<LivingEntity> args) {
        EntityUtil.applyPotions(args, new EffectBuilder(MobEffects.MOVEMENT_SLOWDOWN, 50).level(20), new EffectBuilder(MobEffects.DIG_SLOWDOWN, 50).level(20));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

