/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;

public class CrystalStaff
extends BaseStaff<List<Player>> {
    public CrystalStaff(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_CRYSTEVIA_STAFF_CAST.get();
    }

    @Override
    public Optional<List<Player>> checkPreconditions(LivingEntity caster, ItemStack staff) {
        List players = EntityRetrievalUtil.getPlayers((Entity)caster, (double)20.0, entity -> entity.getHealth() < entity.getMaxHealth() && PlayerUtil.shouldPlayerBeAffected(entity));
        return Optional.ofNullable(players.isEmpty() ? null : players);
    }

    public static Object2IntMap<Item> getDefaultRunes() {
        return (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), runes -> {
            runes.put((Object)((Item)AoAItems.DISTORTION_RUNE.get()), 2);
            runes.put((Object)((Item)AoAItems.LIFE_RUNE.get()), 5);
        });
    }

    @Override
    public void cast(ServerLevel level, ItemStack staff, LivingEntity caster, List<Player> args) {
        float currentTotalHealth = 0.0f;
        float currentMaxHealth = 0.0f;
        for (Player pl : args) {
            currentMaxHealth += pl.getMaxHealth();
            currentTotalHealth += pl.getHealth();
        }
        float healthPerPlayer = currentMaxHealth * (currentTotalHealth / currentMaxHealth * 1.25f) / (float)args.size();
        for (Player pl : args) {
            pl.setHealth(healthPerPlayer);
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 2, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

