/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.scheduling.async.CoralStaffTask;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;
import org.jetbrains.annotations.Nullable;

public class CoralStaff
extends BaseStaff<List<BlockPos>> {
    public CoralStaff(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_CORAL_STAFF_CAST.get();
    }

    public static Object2IntMap<Item> getDefaultRunes() {
        return (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), runes -> {
            runes.put((Object)((Item)AoAItems.WATER_RUNE.get()), 2);
            runes.put((Object)((Item)AoAItems.KINETIC_RUNE.get()), 8);
        });
    }

    @Override
    public Optional<List<BlockPos>> checkPreconditions(LivingEntity caster, ItemStack staff) {
        int y;
        ObjectArrayList coralPositions = new ObjectArrayList();
        BlockPos pos = caster.blockPosition();
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int x = -2; x <= 1; ++x) {
            for (int z = -2; z <= 1; ++z) {
                checkPos.set(pos.getX() + x, pos.getY() - 2, pos.getZ() + z);
                if (this.safeBlockPos(caster, (BlockPos)checkPos, staff)) {
                    coralPositions.add(checkPos.immutable());
                }
                if (!this.safeBlockPos(caster, (BlockPos)checkPos.move(Direction.UP, 4), staff)) continue;
                coralPositions.add(checkPos.immutable());
            }
            for (y = -2; y <= 2; ++y) {
                checkPos.set(pos.getX() + x, pos.getY() + y, pos.getZ() - 2);
                if (this.safeBlockPos(caster, (BlockPos)checkPos, staff)) {
                    coralPositions.add(checkPos.immutable());
                }
                if (!this.safeBlockPos(caster, (BlockPos)checkPos.move(Direction.SOUTH, 4), staff)) continue;
                coralPositions.add(checkPos.immutable());
            }
        }
        for (int z = -2; z <= 2; ++z) {
            for (y = -2; y <= 2; ++y) {
                checkPos.set(pos.getX() - 2, pos.getY() + y, pos.getZ() + z);
                if (this.safeBlockPos(caster, (BlockPos)checkPos, staff)) {
                    coralPositions.add(checkPos.immutable());
                }
                if (!this.safeBlockPos(caster, (BlockPos)checkPos.move(Direction.EAST, 4), staff)) continue;
                coralPositions.add(checkPos.immutable());
            }
        }
        return Optional.ofNullable(coralPositions.isEmpty() ? null : coralPositions);
    }

    @Override
    public void cast(ServerLevel level, ItemStack staff, LivingEntity caster, List<BlockPos> args) {
        if (!level.isClientSide && caster instanceof Player) {
            for (BlockPos pos : args) {
                level.setBlock(pos, Blocks.BRAIN_CORAL_BLOCK.defaultBlockState(), 2);
            }
            level.playSound(null, caster.getX(), caster.getY(), caster.getZ(), (SoundEvent)AoASounds.ITEM_REEF_STAFF_CAST.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            new CoralStaffTask((Level)level, args).schedule(600);
        }
    }

    private boolean safeBlockPos(LivingEntity caster, BlockPos pos, ItemStack staff) {
        return caster.level().getBlockState(pos).getBlock() == Blocks.AIR && WorldUtil.canPlaceBlock((LevelAccessor)caster.level(), pos, (Entity)caster, staff);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

