/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.maul;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoAGameRules;
import net.tslat.aoa3.content.item.weapon.maul.BaseMaul;
import net.tslat.aoa3.library.constant.AttackSpeed;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;

public class VulcammerMaul
extends BaseMaul {
    public VulcammerMaul() {
        super(28.0f, AttackSpeed.THIRD, 8.2, 1750);
    }

    @Override
    protected void doMeleeEffect(ItemStack stack, Entity target, LivingEntity attacker, float attackCooldown) {
        if (attackCooldown > 0.85f) {
            boolean doWorldDamage = AoAGameRules.checkDestructiveWeaponPhysics(attacker.level());
            WorldUtil.createExplosion((Entity)attacker, attacker.level(), (attacker.getX() + target.getX()) / 2.0, (attacker.getY() + target.getY()) / 2.0, (attacker.getZ() + target.getZ()) / 2.0, 2.0f, doWorldDamage ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE, doWorldDamage);
            if (!doWorldDamage) {
                for (LivingEntity entity : attacker.level().getEntitiesOfClass(LivingEntity.class, target.getBoundingBox().inflate(2.0), EntityUtil::isHostileMob)) {
                    entity.igniteForSeconds(3.0f);
                }
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }
}

