/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.gun;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public class LunarAssaultRifle
extends BaseGun {
    private final double minDamage;
    private final double maxDamage;

    public LunarAssaultRifle(Item.Properties properties) {
        super(properties);
        float baseDamage = this.getGunStats(this.getDefaultInstance()).damage();
        this.minDamage = (double)baseDamage - (double)baseDamage / 2.0;
        this.maxDamage = (double)baseDamage + (double)baseDamage / 2.0;
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GUN_GENERIC_FIRE_3.get();
    }

    @Override
    public float getGunDamage(ItemStack stack) {
        return (float)RandomUtil.randomValueBetween((double)this.minDamage, (double)this.maxDamage);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.set(1, (Component)LocaleUtil.getFormattedItemDescriptionText(LocaleUtil.Keys.RANDOM_DAMAGE, LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, new Component[]{LocaleUtil.numToComponent(this.minDamage), LocaleUtil.numToComponent(this.maxDamage)}));
    }
}

